/*
 * Decompiled with CFR 0.152.
 */
package com.qouteall.imm_ptl_peripheral;

import com.google.common.collect.Lists;
import com.qouteall.hiding_in_the_bushes.O_O;
import com.qouteall.imm_ptl_peripheral.CommandStickItem;
import com.qouteall.imm_ptl_peripheral.alternate_dimension.AlternateDimensions;
import com.qouteall.imm_ptl_peripheral.alternate_dimension.FormulaGenerator;
import com.qouteall.imm_ptl_peripheral.altius_world.AltiusGameRule;
import com.qouteall.imm_ptl_peripheral.altius_world.AltiusManagement;
import com.qouteall.imm_ptl_peripheral.guide.IPGuide;
import com.qouteall.imm_ptl_peripheral.portal_generation.IntrinsicPortalGeneration;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_2248;

public class PeripheralModMain {
    public static class_2248 portalHelperBlock;
    public static class_1747 portalHelperBlockItem;

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        IPGuide.initClient();
    }

    public static void init() {
        FormulaGenerator.init();
        IntrinsicPortalGeneration.init();
        AltiusGameRule.init();
        AltiusManagement.init();
        AlternateDimensions.init();
    }

    public static void registerCommandStickTypes() {
        PeripheralModMain.registerPortalSubCommandStick("delete_portal");
        PeripheralModMain.registerPortalSubCommandStick("remove_connected_portals");
        PeripheralModMain.registerPortalSubCommandStick("eradicate_portal_cluster");
        PeripheralModMain.registerPortalSubCommandStick("complete_bi_way_bi_faced_portal");
        PeripheralModMain.registerPortalSubCommandStick("complete_bi_way_portal");
        PeripheralModMain.registerPortalSubCommandStick("move_portal_front", "move_portal 0.5");
        PeripheralModMain.registerPortalSubCommandStick("move_portal_back", "move_portal -0.5");
        PeripheralModMain.registerPortalSubCommandStick("move_portal_destination_front", "move_portal_destination 0.5");
        PeripheralModMain.registerPortalSubCommandStick("move_portal_destination_back", "move_portal_destination -0.5");
        PeripheralModMain.registerPortalSubCommandStick("rotate_x", "rotate_portal_rotation_along x 15");
        PeripheralModMain.registerPortalSubCommandStick("rotate_y", "rotate_portal_rotation_along y 15");
        PeripheralModMain.registerPortalSubCommandStick("rotate_z", "rotate_portal_rotation_along z 15");
        PeripheralModMain.registerPortalSubCommandStick("make_unbreakable", "set_portal_nbt {unbreakable:true}");
        PeripheralModMain.registerPortalSubCommandStick("make_fuse_view", "set_portal_nbt {fuseView:true}");
        PeripheralModMain.registerPortalSubCommandStick("disable_rendering_yourself", "set_portal_nbt {doRenderPlayer:false}");
        PeripheralModMain.registerPortalSubCommandStick("enable_isometric", "debug isometric_enable 50");
        PeripheralModMain.registerPortalSubCommandStick("disable_isometric", "debug isometric_disable");
        PeripheralModMain.registerPortalSubCommandStick("create_5_connected_rooms", "create_connected_rooms roomSize 6 4 6 roomNumber 5");
        if (O_O.getIsPehkuiPresent()) {
            CommandStickItem.registerType("imm_ptl:reset_scale", new CommandStickItem.Data("/scale set pehkui:base 1", "imm_ptl.command.reset_scale", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.reset_scale"})));
            CommandStickItem.registerType("imm_ptl:long_reach", new CommandStickItem.Data("/scale set pehkui:reach 5", "imm_ptl.command.long_reach", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.long_reach"})));
        }
        PeripheralModMain.registerPortalSubCommandStick("goback");
        PeripheralModMain.registerPortalSubCommandStick("show_wiki", "wiki");
    }

    private static void registerPortalSubCommandStick(String name) {
        PeripheralModMain.registerPortalSubCommandStick(name, name);
    }

    private static void registerPortalSubCommandStick(String name, String subCommand) {
        CommandStickItem.registerType("imm_ptl:" + name, new CommandStickItem.Data("/portal " + subCommand, "imm_ptl.command." + name, Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc." + name})));
    }
}

