/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.client.models;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1086;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_4590;
import net.minecraft.class_793;
import net.minecraft.class_807;
import net.minecraft.class_813;
import net.minecraft.class_815;
import net.minecraft.class_816;
import net.minecraft.class_819;
import ru.bclib.client.models.BasePatterns;
import ru.bclib.client.models.PatternsHelper;

@Environment(value=EnvType.CLIENT)
public class ModelsHelper {
    public static class_793 fromPattern(Optional<String> pattern) {
        return pattern.map(class_793::method_3430).orElse(null);
    }

    public static class_793 createItemModel(class_2960 resourceLocation) {
        return ModelsHelper.fromPattern(PatternsHelper.createItemGenerated(resourceLocation));
    }

    public static class_793 createHandheldItem(class_2960 resourceLocation) {
        return ModelsHelper.fromPattern(PatternsHelper.createItemHandheld(resourceLocation));
    }

    public static class_793 createBlockItem(class_2960 resourceLocation) {
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.ITEM_BLOCK, resourceLocation);
        return ModelsHelper.fromPattern(pattern);
    }

    public static class_793 createBlockEmpty(class_2960 resourceLocation) {
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.BLOCK_EMPTY, resourceLocation);
        return ModelsHelper.fromPattern(pattern);
    }

    public static class_807 createMultiVariant(class_2960 resourceLocation, class_4590 transform, boolean uvLock) {
        class_813 variant = new class_813(resourceLocation, transform, uvLock, 1);
        return new class_807((List)Lists.newArrayList((Object[])new class_813[]{variant}));
    }

    public static class_807 createBlockSimple(class_2960 resourceLocation) {
        return ModelsHelper.createMultiVariant(resourceLocation, class_4590.method_22931(), false);
    }

    public static class_807 createFacingModel(class_2960 resourceLocation, class_2350 facing, boolean uvLock, boolean inverted) {
        if (inverted) {
            facing = facing.method_10153();
        }
        class_1086 rotation = class_1086.method_4699((int)0, (int)((int)facing.method_10144()));
        return ModelsHelper.createMultiVariant(resourceLocation, rotation.method_3509(), uvLock);
    }

    public static class_807 createRotatedModel(class_2960 resourceLocation, class_2350.class_2351 axis) {
        class_1086 rotation = class_1086.field_5350;
        switch (axis) {
            case field_11048: {
                rotation = class_1086.field_5360;
                break;
            }
            case field_11051: {
                rotation = class_1086.field_5351;
                break;
            }
        }
        return ModelsHelper.createMultiVariant(resourceLocation, rotation.method_3509(), false);
    }

    public static class_807 createRandomTopModel(class_2960 resourceLocation) {
        return new class_807((List)Lists.newArrayList((Object[])new class_813[]{new class_813(resourceLocation, class_4590.method_22931(), false, 1), new class_813(resourceLocation, class_1086.field_5366.method_3509(), false, 1), new class_813(resourceLocation, class_1086.field_5355.method_3509(), false, 1), new class_813(resourceLocation, class_1086.field_5347.method_3509(), false, 1)}));
    }

    public static class MultiPartBuilder {
        private static final MultiPartBuilder BUILDER = new MultiPartBuilder();
        private final List<ModelPart> modelParts = Lists.newArrayList();
        private class_2689<class_2248, class_2680> stateDefinition;

        public static MultiPartBuilder create(class_2689<class_2248, class_2680> stateDefinition) {
            MultiPartBuilder.BUILDER.stateDefinition = stateDefinition;
            MultiPartBuilder.BUILDER.modelParts.clear();
            return BUILDER;
        }

        private MultiPartBuilder() {
        }

        public ModelPart part(class_2960 modelId) {
            return new ModelPart(modelId);
        }

        public class_816 build() {
            if (this.modelParts.size() > 0) {
                ArrayList selectors = Lists.newArrayList();
                this.modelParts.forEach(modelPart -> {
                    class_807 variant = ModelsHelper.createMultiVariant(((ModelPart)modelPart).modelId, ((ModelPart)modelPart).transform, ((ModelPart)modelPart).uvLock);
                    selectors.add(new class_819(((ModelPart)modelPart).condition, variant));
                });
                this.modelParts.clear();
                return new class_816(this.stateDefinition, (List)selectors);
            }
            throw new IllegalStateException("At least one model part need to be created.");
        }

        public class ModelPart {
            private final class_2960 modelId;
            private class_4590 transform = class_4590.method_22931();
            private class_815 condition = class_815.field_16900;
            private boolean uvLock = false;

            private ModelPart(class_2960 modelId) {
                this.modelId = modelId;
            }

            public ModelPart setCondition(Function<class_2680, Boolean> condition) {
                this.condition = stateDefinition -> condition::apply;
                return this;
            }

            public ModelPart setTransformation(class_4590 transform) {
                this.transform = transform;
                return this;
            }

            public ModelPart setUVLock(boolean value) {
                this.uvLock = value;
                return this;
            }

            public void add() {
                MultiPartBuilder.this.modelParts.add(this);
            }
        }
    }
}

