/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.features;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3531;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.server.MinecraftServer;
import ru.bclib.api.BiomeAPI;
import ru.bclib.api.TagAPI;
import ru.bclib.util.BlocksHelper;
import ru.bclib.world.features.DefaultFeature;
import ru.bclib.world.processors.DestructionStructureProcessor;

public abstract class NBTStructureFeature
extends DefaultFeature {
    protected static final DestructionStructureProcessor DESTRUCTION = new DestructionStructureProcessor();

    protected abstract class_3499 getStructure(class_5281 var1, class_2338 var2, Random var3);

    protected abstract boolean canSpawn(class_5281 var1, class_2338 var2, Random var3);

    protected abstract class_2470 getRotation(class_5281 var1, class_2338 var2, Random var3);

    protected abstract class_2415 getMirror(class_5281 var1, class_2338 var2, Random var3);

    protected abstract int getYOffset(class_3499 var1, class_5281 var2, class_2338 var3, Random var4);

    protected abstract TerrainMerge getTerrainMerge(class_5281 var1, class_2338 var2, Random var3);

    protected abstract void addStructureData(class_3492 var1);

    protected class_2338 getGround(class_5281 world, class_2338 center) {
        class_1959 biome = world.method_23753(center);
        class_2960 id = BiomeAPI.getBiomeID(biome);
        if (id.method_12836().contains("moutain") || id.method_12836().contains("lake")) {
            int y = this.getAverageY(world, center);
            return new class_2338(center.method_10263(), y, center.method_10260());
        }
        int y = this.getAverageYWG(world, center);
        return new class_2338(center.method_10263(), y, center.method_10260());
    }

    protected int getAverageY(class_5281 world, class_2338 center) {
        int y = NBTStructureFeature.getYOnSurface(world, center.method_10263(), center.method_10260());
        y += NBTStructureFeature.getYOnSurface(world, center.method_10263() - 2, center.method_10260() - 2);
        y += NBTStructureFeature.getYOnSurface(world, center.method_10263() + 2, center.method_10260() - 2);
        y += NBTStructureFeature.getYOnSurface(world, center.method_10263() - 2, center.method_10260() + 2);
        return (y += NBTStructureFeature.getYOnSurface(world, center.method_10263() + 2, center.method_10260() + 2)) / 5;
    }

    protected int getAverageYWG(class_5281 world, class_2338 center) {
        int y = NBTStructureFeature.getYOnSurfaceWG(world, center.method_10263(), center.method_10260());
        y += NBTStructureFeature.getYOnSurfaceWG(world, center.method_10263() - 2, center.method_10260() - 2);
        y += NBTStructureFeature.getYOnSurfaceWG(world, center.method_10263() + 2, center.method_10260() - 2);
        y += NBTStructureFeature.getYOnSurfaceWG(world, center.method_10263() - 2, center.method_10260() + 2);
        return (y += NBTStructureFeature.getYOnSurfaceWG(world, center.method_10263() + 2, center.method_10260() + 2)) / 5;
    }

    public boolean place(class_5281 world, class_2794 chunkGenerator, Random random, class_2338 center, class_3111 featureConfig) {
        center = new class_2338(center.method_10263() >> 4 << 4 | 8, 128, center.method_10260() >> 4 << 4 | 8);
        if (!this.canSpawn(world, center = this.getGround(world, center), random)) {
            return false;
        }
        int posY = center.method_10264() + 1;
        class_3499 structure = this.getStructure(world, center, random);
        class_2470 rotation = this.getRotation(world, center, random);
        class_2415 mirror = this.getMirror(world, center, random);
        class_2338 offset = class_3499.method_15168((class_2338)structure.method_15160(), (class_2415)mirror, (class_2470)rotation, (class_2338)class_2338.field_10980);
        center = center.method_10080(0.0, (double)this.getYOffset(structure, world, center, random) + 0.5, 0.0);
        class_3341 bounds = this.makeBox(center);
        class_3492 placementData = new class_3492().method_15123(rotation).method_15125(mirror).method_15126(bounds);
        this.addStructureData(placementData);
        center = center.method_10080((double)(-offset.method_10263()) * 0.5, 0.0, (double)(-offset.method_10260()) * 0.5);
        structure.method_15182((class_5425)world, center, placementData, random);
        TerrainMerge merge = this.getTerrainMerge(world, center, random);
        int x1 = center.method_10263();
        int z1 = center.method_10260();
        int x2 = x1 + offset.method_10263();
        int z2 = z1 + offset.method_10260();
        if (merge != TerrainMerge.NONE) {
            int a;
            class_2338.class_2339 mut = new class_2338.class_2339();
            if (x2 < x1) {
                a = x1;
                x1 = x2;
                x2 = a;
            }
            if (z2 < z1) {
                a = z1;
                z1 = z2;
                z2 = a;
            }
            int surfMax = posY - 1;
            for (int x = x1; x <= x2; ++x) {
                mut.method_20787(x);
                block1: for (int z = z1; z <= z2; ++z) {
                    mut.method_20788(z);
                    mut.method_10099(surfMax);
                    class_2680 state = world.method_8320((class_2338)mut);
                    if (state.method_26164(TagAPI.GEN_TERRAIN) || !state.method_26206((class_1922)world, (class_2338)mut, class_2350.field_11033)) continue;
                    for (int i = 0; i < 10; ++i) {
                        class_3531 config;
                        mut.method_10099(mut.method_10264() - 1);
                        class_2680 stateSt = world.method_8320((class_2338)mut);
                        if (!stateSt.method_26164(TagAPI.GEN_TERRAIN)) {
                            if (merge == TerrainMerge.SURFACE) {
                                config = world.method_23753((class_2338)mut).method_30970().method_30985();
                                boolean isTop = mut.method_10264() == surfMax && state.method_26207().method_15804();
                                class_2680 top = isTop ? config.method_15337() : config.method_15336();
                                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, top);
                                continue;
                            }
                            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, state);
                            continue;
                        }
                        if (!stateSt.method_26164(TagAPI.END_GROUND) || !state.method_26207().method_15804()) continue block1;
                        if (merge == TerrainMerge.SURFACE) {
                            config = world.method_23753((class_2338)mut).method_30970().method_30985();
                            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, config.method_15336());
                            continue block1;
                        }
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, state);
                        continue block1;
                    }
                }
            }
        }
        return true;
    }

    protected class_3341 makeBox(class_2338 pos) {
        int sx = (pos.method_10263() >> 4 << 4) - 16;
        int sz = (pos.method_10260() >> 4 << 4) - 16;
        int ex = sx + 47;
        int ez = sz + 47;
        return class_3341.method_14666((int)sx, (int)0, (int)sz, (int)ex, (int)255, (int)ez);
    }

    protected static class_3499 readStructure(class_2960 resource) {
        String ns = resource.method_12836();
        String nm = resource.method_12832();
        try {
            InputStream inputstream = MinecraftServer.class.getResourceAsStream("/data/" + ns + "/structures/" + nm + ".nbt");
            return NBTStructureFeature.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class_3499 readStructureFromStream(InputStream stream) throws IOException {
        class_2487 nbttagcompound = class_2507.method_10629((InputStream)stream);
        class_3499 template = new class_3499();
        template.method_15183(nbttagcompound);
        return template;
    }

    public static enum TerrainMerge {
        NONE,
        SURFACE,
        OBJECT;


        public static TerrainMerge getFromString(String type) {
            if (type.equals("surface")) {
                return SURFACE;
            }
            if (type.equals("object")) {
                return OBJECT;
            }
            return NONE;
        }
    }
}

