/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.generator;

import java.util.Random;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.BiomeMap;
import ru.bclib.world.generator.BiomePicker;

public class BiomeChunk {
    protected static final int WIDTH = 16;
    private static final int SM_WIDTH = 8;
    private static final int MASK_OFFSET = 7;
    protected static final int MASK_WIDTH = 15;
    private final BCLBiome[][] biomes;

    public BiomeChunk(BiomeMap map, Random random, BiomePicker picker) {
        int z;
        int x;
        BCLBiome[][] PreBio = new BCLBiome[8][8];
        this.biomes = new BCLBiome[16][16];
        for (x = 0; x < 8; ++x) {
            for (z = 0; z < 8; ++z) {
                PreBio[x][z] = picker.getBiome(random);
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                this.biomes[x][z] = PreBio[this.offsetXZ(x, random)][this.offsetXZ(z, random)].getSubBiome(random);
            }
        }
    }

    public BCLBiome getBiome(int x, int z) {
        return this.biomes[x & 0xF][z & 0xF];
    }

    private int offsetXZ(int x, Random random) {
        return x + random.nextInt(2) >> 1 & 7;
    }
}

