/*
 * Decompiled with CFR 0.152.
 */
package com.aqupd.grizzlybear.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;

public class AqConfig {
    public static final AqConfig INSTANCE = new AqConfig();
    private boolean loaded;
    private final Properties aqprop = new Properties();
    private File file = new File("./config/AqMods/grizzly.config");

    private AqConfig() {
    }

    public boolean getBooleanProperty(String key) {
        if (!this.loaded) {
            this.load();
        }
        return Boolean.parseBoolean(this.aqprop.getProperty(key));
    }

    public String getStringProperty(String key) {
        if (!this.loaded) {
            this.load();
        }
        return this.aqprop.getProperty(key);
    }

    public int getNumberProperty(String key) {
        if (!this.loaded) {
            this.load();
        }
        return Integer.parseInt(this.aqprop.getProperty(key));
    }

    public double getDoubleProperty(String key) {
        if (!this.loaded) {
            this.load();
        }
        return Double.parseDouble(this.aqprop.getProperty(key));
    }

    private void load() {
        this.loaded = true;
        try {
            new File("./config/AqMods").mkdir();
            if (this.file.exists()) {
                FileReader reader = new FileReader(this.file);
                this.aqprop.load(reader);
                ((Reader)reader).close();
            } else {
                FileOutputStream writer = new FileOutputStream(this.file);
                this.file.createNewFile();
                this.aqprop.setProperty("config.version", "1");
                this.aqprop.setProperty("debug", "false");
                this.aqprop.setProperty("spawn.weight", "50");
                this.aqprop.setProperty("spawn.min", "2");
                this.aqprop.setProperty("spawn.max", "4");
                this.aqprop.setProperty("entity.angertimemin", "20");
                this.aqprop.setProperty("entity.angertimemax", "39");
                this.aqprop.setProperty("entity.friendly", "false");
                this.aqprop.setProperty("entity.health", "30.0");
                this.aqprop.setProperty("entity.speed", "0.25");
                this.aqprop.setProperty("entity.follow", "20.0");
                this.aqprop.setProperty("entity.damage", "6.0");
                this.aqprop.setProperty("spawn.biomes", "TAIGA");
                this.aqprop.store(writer, "Configuration file for Grizzly bear mod");
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

