/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.mixin.AccessorIngredient;

public final class ItemStackUtil {
    private static final Gson GSON = new GsonBuilder().create();

    private ItemStackUtil() {
    }

    public static String serializeStack(class_1799 stack) {
        StringBuilder builder = new StringBuilder();
        builder.append(class_2378.field_11142.method_10221((Object)stack.method_7909()).toString());
        int count = stack.method_7947();
        if (count > 1) {
            builder.append("#");
            builder.append(count);
        }
        if (stack.method_7985()) {
            Dynamic dyn = new Dynamic((DynamicOps)class_2509.field_11560, (Object)stack.method_7969());
            JsonElement j = (JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue();
            builder.append(GSON.toJson(j));
        }
        return builder.toString();
    }

    public static class_1799 loadStackFromString(String res) {
        String[] tokens;
        String nbt = "";
        int nbtStart = res.indexOf("{");
        if (nbtStart > 0) {
            nbt = res.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            res = res.substring(0, nbtStart);
        }
        String[] upper = res.split("#");
        String count = "1";
        if (upper.length > 1) {
            res = upper[0];
            count = upper[1];
        }
        if ((tokens = res.split(":")).length < 2) {
            return class_1799.field_8037;
        }
        int countn = Integer.parseInt(count);
        class_2960 key = new class_2960(tokens[0], tokens[1]);
        Optional maybeItem = class_2378.field_11142.method_17966(key);
        if (!maybeItem.isPresent()) {
            throw new RuntimeException("Unknown item ID: " + key);
        }
        class_1792 item = (class_1792)maybeItem.get();
        class_1799 stack = new class_1799((class_1935)item, countn);
        if (!nbt.isEmpty()) {
            try {
                stack.method_7980(class_2522.method_10718((String)nbt));
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException("Failed to parse ItemStack JSON", e);
            }
        }
        return stack;
    }

    public static String serializeIngredient(class_1856 ingredient) {
        ((AccessorIngredient)ingredient).patchouli_callCacheMatchingStacks();
        class_1799[] stacks = ((AccessorIngredient)ingredient).getMatchingStacks();
        CharSequence[] stacksSerialized = new String[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacksSerialized[i] = ItemStackUtil.serializeStack(stacks[i]);
        }
        return String.join((CharSequence)",", stacksSerialized);
    }

    public static class_1856 loadIngredientFromString(String ingredientString) {
        return class_1856.method_8101((class_1799[])ItemStackUtil.loadStackListFromString(ingredientString).toArray(new class_1799[0]));
    }

    public static String serializeStackList(List<class_1799> stacks) {
        StringJoiner joiner = new StringJoiner(",");
        for (class_1799 stack : stacks) {
            joiner.add(ItemStackUtil.serializeStack(stack));
        }
        return joiner.toString();
    }

    public static List<class_1799> loadStackListFromString(String ingredientString) {
        String[] stacksSerialized = ItemStackUtil.splitStacksFromSerializedIngredient(ingredientString);
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (int i = 0; i < stacksSerialized.length; ++i) {
            if (stacksSerialized[i].startsWith("tag:")) {
                class_3494 tag = class_3489.method_15106().method_30210(new class_2960(stacksSerialized[i].substring(4)));
                if (tag == null) continue;
                for (class_1792 item : tag.method_15138()) {
                    stacks.add(new class_1799((class_1935)item));
                }
                continue;
            }
            stacks.add(ItemStackUtil.loadStackFromString(stacksSerialized[i]));
        }
        return stacks;
    }

    public static StackWrapper wrapStack(class_1799 stack) {
        return stack.method_7960() ? StackWrapper.EMPTY_WRAPPER : new StackWrapper(stack);
    }

    @Nullable
    public static Book getBookFromStack(class_1799 stack) {
        if (stack.method_7909() instanceof ItemModBook) {
            return ItemModBook.getBook(stack);
        }
        Collection<Book> books = BookRegistry.INSTANCE.books.values();
        for (Book b : books) {
            if (!b.getBookItem().method_7929(stack)) continue;
            return b;
        }
        return null;
    }

    private static String[] splitStacksFromSerializedIngredient(String ingredientSerialized) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int braces = 0;
        Character insideString = null;
        block7: for (int i = 0; i < ingredientSerialized.length(); ++i) {
            switch (ingredientSerialized.charAt(i)) {
                case '{': {
                    if (insideString != null) continue block7;
                    ++braces;
                    continue block7;
                }
                case '}': {
                    if (insideString != null) continue block7;
                    --braces;
                    continue block7;
                }
                case '\'': {
                    insideString = insideString == null ? Character.valueOf('\'') : null;
                    continue block7;
                }
                case '\"': {
                    insideString = insideString == null ? Character.valueOf('\"') : null;
                    continue block7;
                }
                case ',': {
                    if (braces > 0) continue block7;
                    result.add(ingredientSerialized.substring(lastIndex, i));
                    lastIndex = i + 1;
                }
            }
        }
        result.add(ingredientSerialized.substring(lastIndex));
        return result.toArray(new String[0]);
    }

    public static class_1799 loadStackFromJson(JsonObject json) {
        String itemName = json.get("item").getAsString();
        class_1792 item = (class_1792)class_2378.field_11142.method_17966(new class_2960(itemName)).orElseThrow(() -> new IllegalArgumentException("Unknown item '" + itemName + "'"));
        class_1799 stack = new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                class_2487 nbt = element.isJsonObject() ? class_2522.method_10718((String)GSON.toJson(element)) : class_2522.method_10718((String)element.getAsString());
                stack.method_7980(nbt);
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Invalid NBT Entry: " + e.toString(), e);
            }
        }
        return stack;
    }

    public static class StackWrapper {
        public static final StackWrapper EMPTY_WRAPPER = new StackWrapper(class_1799.field_8037);
        public final class_1799 stack;

        public StackWrapper(class_1799 stack) {
            this.stack = stack;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof StackWrapper && class_1799.method_7987((class_1799)this.stack, (class_1799)((StackWrapper)obj).stack);
        }

        public int hashCode() {
            return this.stack.method_7909().hashCode();
        }

        public String toString() {
            return "Wrapper[" + this.stack.toString() + "]";
        }
    }
}

