/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2403;
import net.minecraft.class_2408;
import net.minecraft.class_2466;
import net.minecraft.class_2471;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_5120;
import net.minecraft.class_5394;
import net.minecraft.class_5413;
import net.minecraft.class_5415;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemTagger<T>
extends class_2471 {
    protected static final class_5120<class_1792> REQUIRED_TAGS = class_5413.method_30201((class_2960)new class_2960("croptopia", "etem"), class_5415::method_30218);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2960, class_3494.class_3495> tagBuilders = Maps.newLinkedHashMap();
    private static final Logger LOGGER = LogManager.getLogger();

    public ItemTagger(class_2403 dataGenerator, class_2466 blockTagsProvider) {
        super(dataGenerator, blockTagsProvider);
    }

    public void addSeedTag(class_1792 item, class_2960 itemName) {
        class_3494.class_5123 identifier = REQUIRED_TAGS.method_26773(new class_2960("croptopia", "seeds").toString());
        this.createTag((class_3494.class_5123<class_1792>)identifier, item);
    }

    public void addTag(class_1792 item, class_2960 itemName) {
        class_2960 pluralID = new class_2960(itemName.method_12836(), itemName.method_12832() + "s");
        class_3494.class_5123 identifier = REQUIRED_TAGS.method_26773(pluralID.toString());
        this.createTag((class_3494.class_5123<class_1792>)identifier, item);
    }

    protected void createTag(class_3494.class_5123<class_1792> identified, class_1792 item) {
        this.tagBuilders.computeIfAbsent(identified.method_26791(), identifier -> new class_3494.class_3495()).method_26784(this.field_11482.method_10221((Object)item), "");
    }

    protected void createTaggedItem(class_3494.class_5123<class_1792> identified, class_1792 item) {
        this.tagBuilders.computeIfAbsent(identified.method_26791(), identifier -> new class_3494.class_3495()).method_26787(this.field_11482.method_10221((Object)item), "");
    }

    public void method_10319(class_2408 cache) {
        class_5394 tag = class_5394.method_29898();
        Function<class_2960, class_3494> function = arg_0 -> this.lambda$run$2((class_3494)tag, arg_0);
        Function<class_2960, Object> function2 = identifier -> this.field_11482.method_17966(identifier).orElse(null);
        this.tagBuilders.forEach((identifier, builder) -> {
            List list = builder.method_26786(function, function2).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", identifier, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject jsonObject = builder.method_26788();
            Path path = this.method_10510((class_2960)identifier);
            try {
                String string = GSON.toJson((JsonElement)jsonObject);
                String string2 = field_11280.hashUnencodedChars((CharSequence)string).toString();
                if (!Objects.equals(cache.method_10323(path), string2) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedWriter.write(string);
                    }
                }
                cache.method_10325(path, string2);
            }
            catch (IOException var24) {
                LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)var24);
            }
        });
    }

    private /* synthetic */ class_3494 lambda$run$2(class_3494 tag, class_2960 identifier) {
        return this.tagBuilders.containsKey(identifier) ? tag : null;
    }
}

