/*
 * Decompiled with CFR 0.152.
 */
package supercoder79.cavebiomes.world.layer;

import supercoder79.cavebiomes.world.layer.CaveLayer;
import supercoder79.cavebiomes.world.layer.ScaleCaveLayer;
import supercoder79.cavebiomes.world.layer.water.WaterBorderLayer;
import supercoder79.cavebiomes.world.layer.water.WaterInitLayer;

public class WaterGenerator {
    public static final int BORDER_BITS = 65280;
    private static CaveLayer layer;
    private static long seed;

    public static int getSample(long worldSeed, int x, int z) {
        if (layer == null || seed != worldSeed) {
            layer = WaterGenerator.build(worldSeed);
            seed = worldSeed;
        }
        return layer.sample(x, z);
    }

    public static int getWaterLevel(int sample) {
        return sample & 0xFF;
    }

    public static int getBorder(int sample) {
        return (sample & 0xFF00) >> 8;
    }

    private static CaveLayer build(long seed) {
        CaveLayer factory = new WaterInitLayer(seed, 150);
        for (int i = 0; i < 8; ++i) {
            factory = new ScaleCaveLayer(seed, 100 + i, factory);
        }
        factory = new WaterBorderLayer(seed, 3).setParent(factory);
        return factory;
    }
}

