/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.access.MovingEntity;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.power.ActionOnLandPower;
import io.github.apace100.origins.power.EntityGlowPower;
import io.github.apace100.origins.power.FireImmunityPower;
import io.github.apace100.origins.power.IgnoreWaterPower;
import io.github.apace100.origins.power.InvisibilityPower;
import io.github.apace100.origins.power.InvulnerablePower;
import io.github.apace100.origins.power.PhasingPower;
import io.github.apace100.origins.power.SwimmingPower;
import io.github.apace100.origins.registry.ModComponents;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements MovingEntity {
    @Shadow
    public class_1937 field_6002;
    @Shadow
    public float field_5994;
    @Shadow
    protected boolean field_5952;
    @Unique
    private boolean wasGrounded = false;
    private boolean isMoving;
    private float distanceBefore;

    @Inject(method={"isFireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeFullyFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (OriginComponent.hasPower((class_1297)this, FireImmunityPower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Shadow
    public abstract double method_5861(class_3494<class_3611> var1);

    @Shadow
    public abstract class_243 method_18798();

    @Inject(method={"isTouchingWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeEntitiesIgnoreWater(CallbackInfoReturnable<Boolean> cir) {
        if (OriginComponent.hasPower((class_1297)this, IgnoreWaterPower.class)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    private void makeEntitiesGlow(CallbackInfoReturnable<Boolean> cir) {
        class_746 player = class_310.method_1551().field_1724;
        class_1297 thisEntity = (class_1297)this;
        if (player != null && player != thisEntity && thisEntity instanceof class_1309 && OriginComponent.getPowers((class_1297)player, EntityGlowPower.class).stream().anyMatch(p -> p.doesApply(thisEntity))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"move"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiler/Profiler;push(Ljava/lang/String;)V", args={"ldc=rest"})})
    private void checkWasGrounded(class_1313 type, class_243 movement, CallbackInfo ci) {
        this.wasGrounded = this.field_5952;
    }

    @Inject(method={"fall"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;fallDistance:F", opcode=181, ordinal=0)})
    @Environment(value=EnvType.CLIENT)
    private void invokeActionOnSoftLand(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition, CallbackInfo ci) {
        if (!this.wasGrounded && this instanceof class_1657) {
            OriginComponent.getPowers((class_1297)this, ActionOnLandPower.class).forEach(ActionOnLandPower::executeAction);
            ClientPlayNetworking.send((class_2960)ModPackets.PLAYER_LANDED, (class_2540)PacketByteBufs.create());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    private void makeOriginInvulnerable(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof class_1657) {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)this);
            if (!component.hasAllOrigins()) {
                cir.setReturnValue((Object)true);
            }
            if (component.getPowers(InvulnerablePower.class).stream().anyMatch(inv -> inv.doesApply(damageSource))) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isWet()Z"))
    private boolean preventExtinguishingFromSwimming(class_1297 entity) {
        if (OriginComponent.hasPower(entity, SwimmingPower.class) && entity.method_5681() && !(this.method_5861((class_3494<class_3611>)class_3486.field_15517) > 0.0)) {
            return false;
        }
        return entity.method_5637();
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvisible"}, cancellable=true)
    private void phantomInvisibility(CallbackInfoReturnable<Boolean> info) {
        if (OriginComponent.hasPower((class_1297)this, InvisibilityPower.class)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;<init>(DDD)V")}, method={"pushOutOfBlocks"}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfo info) {
        List<PhasingPower> powers = OriginComponent.getPowers((class_1297)this, PhasingPower.class);
        if (powers.size() > 0 && powers.stream().anyMatch(phasingPower -> phasingPower.doesApply(new class_2338(x, y, z)))) {
            info.cancel();
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void saveDistanceTraveled(class_1313 type, class_243 movement, CallbackInfo ci) {
        this.isMoving = false;
        this.distanceBefore = this.field_5994;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;pop()V")})
    private void checkIsMoving(class_1313 type, class_243 movement, CallbackInfo ci) {
        if (this.field_5994 > this.distanceBefore) {
            this.isMoving = true;
        }
    }

    @Override
    public boolean isMoving() {
        return this.isMoving;
    }
}

