/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeReference;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModLoot;
import java.util.Optional;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class PowerLootCondition
implements class_5341 {
    private final PowerType<?> powerType;

    private PowerLootCondition(class_2960 powerId) {
        this(new PowerTypeReference(powerId));
    }

    private PowerLootCondition(PowerType<?> powerType) {
        this.powerType = powerType;
    }

    public class_5342 method_29325() {
        return ModLoot.POWER_LOOT_CONDITION;
    }

    public boolean test(class_47 lootContext) {
        Optional optional = ModComponents.ORIGIN.maybeGet(lootContext.method_296(class_181.field_1226));
        if (optional.isPresent()) {
            OriginComponent component = (OriginComponent)optional.get();
            return component.hasPower(this.powerType);
        }
        return false;
    }

    public static class_5341.class_210 builder(String powerId) {
        return PowerLootCondition.builder(new class_2960(powerId));
    }

    public static class_5341.class_210 builder(class_2960 powerId) {
        return PowerLootCondition.builder(new PowerTypeReference(powerId));
    }

    public static class_5341.class_210 builder(PowerType<?> powerType) {
        return () -> new PowerLootCondition(powerType);
    }

    public static class Serializer
    implements class_5335<PowerLootCondition> {
        public void toJson(JsonObject jsonObject, PowerLootCondition originLootCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("power", originLootCondition.powerType.getIdentifier().toString());
        }

        public PowerLootCondition fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new PowerLootCondition(new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"power")));
        }
    }
}

