/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.explosions;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_5362;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1927.class})
public abstract class ExplosionMixin {
    @Shadow
    @Final
    private float field_9190;
    @Shadow
    @Final
    private double field_9195;
    @Shadow
    @Final
    private double field_9192;
    @Shadow
    @Final
    private double field_9189;
    @Shadow
    @Final
    private class_1937 field_9187;
    @Shadow
    @Final
    private class_5362 field_25400;
    @Shadow
    @Final
    private boolean field_9186;
    private final class_2338.class_2339 cachedPos = new class_2338.class_2339();
    private int prevChunkX = Integer.MIN_VALUE;
    private int prevChunkZ = Integer.MIN_VALUE;
    private class_2791 prevChunk;
    private boolean explodeAirBlocks;

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/damage/DamageSource;Lnet/minecraft/world/explosion/ExplosionBehavior;DDDFZLnet/minecraft/world/explosion/Explosion$DestructionType;)V"}, at={@At(value="TAIL")})
    private void init(class_1937 world, class_1297 entity, class_1282 damageSource, class_5362 explosionBehavior, double d, double e, double f, float g, boolean bl, class_1927.class_4179 destructionType, CallbackInfo ci) {
        boolean explodeAir = this.field_9186;
        if (!explodeAir && this.field_9187.method_8597().method_28540()) {
            float overestimatedExplosionRange = 8 + (int)(6.0f * this.field_9190);
            boolean endPortalX = false;
            boolean endPortalZ = false;
            if ((double)overestimatedExplosionRange > Math.abs(this.field_9195 - (double)endPortalX) && (double)overestimatedExplosionRange > Math.abs(this.field_9189 - (double)endPortalZ)) {
                explodeAir = true;
            }
        }
        this.explodeAirBlocks = explodeAir;
    }

    @Redirect(method={"collectBlocksAndDamageEntities"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Sets;newHashSet()Ljava/util/HashSet;"))
    public HashSet<class_2338> skipNewHashSet() {
        return null;
    }

    @ModifyConstant(method={"collectBlocksAndDamageEntities"}, constant={@Constant(intValue=16, ordinal=1)})
    public int skipLoop(int prevValue) {
        return 0;
    }

    @Redirect(method={"collectBlocksAndDamageEntities"}, at=@At(value="INVOKE", target="Ljava/util/List;addAll(Ljava/util/Collection;)Z"))
    public boolean collectBlocks(List<class_2338> affectedBlocks, Collection<class_2338> collection) {
        LongOpenHashSet touched = new LongOpenHashSet(0);
        Random random = this.field_9187.field_9229;
        for (int rayX = 0; rayX < 16; ++rayX) {
            boolean xPlane = rayX == 0 || rayX == 15;
            double vecX = (float)rayX / 15.0f * 2.0f - 1.0f;
            for (int rayY = 0; rayY < 16; ++rayY) {
                boolean yPlane = rayY == 0 || rayY == 15;
                double vecY = (float)rayY / 15.0f * 2.0f - 1.0f;
                for (int rayZ = 0; rayZ < 16; ++rayZ) {
                    boolean zPlane;
                    boolean bl = zPlane = rayZ == 0 || rayZ == 15;
                    if (!xPlane && !yPlane && !zPlane) continue;
                    double vecZ = (float)rayZ / 15.0f * 2.0f - 1.0f;
                    this.performRayCast(random, vecX, vecY, vecZ, touched);
                }
            }
        }
        LongIterator it = touched.iterator();
        boolean added = false;
        while (it.hasNext()) {
            added |= affectedBlocks.add(class_2338.method_10092((long)it.nextLong()));
        }
        return added;
    }

    private void performRayCast(Random random, double vecX, double vecY, double vecZ, LongOpenHashSet touched) {
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        double normX = vecX / dist * 0.3;
        double normY = vecY / dist * 0.3;
        double normZ = vecZ / dist * 0.3;
        float strength = this.field_9190 * (0.7f + random.nextFloat() * 0.6f);
        double stepX = this.field_9195;
        double stepY = this.field_9192;
        double stepZ = this.field_9189;
        int prevX = Integer.MIN_VALUE;
        int prevY = Integer.MIN_VALUE;
        int prevZ = Integer.MIN_VALUE;
        float prevResistance = 0.0f;
        while (strength > 0.0f) {
            float resistance;
            int blockX = class_3532.method_15357((double)stepX);
            int blockY = class_3532.method_15357((double)stepY);
            int blockZ = class_3532.method_15357((double)stepZ);
            if (prevX != blockX || prevY != blockY || prevZ != blockZ) {
                resistance = this.traverseBlock(strength, blockX, blockY, blockZ, touched);
                prevX = blockX;
                prevY = blockY;
                prevZ = blockZ;
                prevResistance = resistance;
            } else {
                resistance = prevResistance;
            }
            strength -= resistance;
            strength -= 0.22500001f;
            stepX += normX;
            stepY += normY;
            stepZ += normZ;
        }
    }

    private float traverseBlock(float strength, int blockX, int blockY, int blockZ, LongOpenHashSet touched) {
        float reducedStrength;
        Optional blastResistance;
        class_2826 section;
        class_2338.class_2339 pos = this.cachedPos.method_10103(blockX, blockY, blockZ);
        if (class_1937.method_8476((int)blockY)) {
            Optional blastResistance2 = this.field_25400.method_29555((class_1927)this, (class_1922)this.field_9187, (class_2338)pos, class_2246.field_10124.method_9564(), class_3612.field_15906.method_15785());
            if (blastResistance2.isPresent()) {
                return (((Float)blastResistance2.get()).floatValue() + 0.3f) * 0.3f;
            }
            return 0.0f;
        }
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        if (this.prevChunkX != chunkX || this.prevChunkZ != chunkZ) {
            this.prevChunk = this.field_9187.method_8497(chunkX, chunkZ);
            this.prevChunkX = chunkX;
            this.prevChunkZ = chunkZ;
        }
        class_2791 chunk = this.prevChunk;
        class_2680 blockState = class_2246.field_10124.method_9564();
        float totalResistance = 0.0f;
        if (chunk != null && (section = chunk.method_12006()[blockY >> 4]) != null && !section.method_12261() && (blockState = section.method_12254(blockX & 0xF, blockY & 0xF, blockZ & 0xF)).method_26204() != class_2246.field_10124) {
            class_3610 fluidState = blockState.method_26227();
            blastResistance = this.field_25400.method_29555((class_1927)this, (class_1922)this.field_9187, (class_2338)pos, blockState, fluidState);
        } else {
            blastResistance = this.field_25400.method_29555((class_1927)this, (class_1922)this.field_9187, (class_2338)pos, class_2246.field_10124.method_9564(), class_3612.field_15906.method_15785());
        }
        if (blastResistance.isPresent()) {
            totalResistance = (((Float)blastResistance.get()).floatValue() + 0.3f) * 0.3f;
        }
        if ((reducedStrength = strength - totalResistance) > 0.0f && (this.explodeAirBlocks || !blockState.method_26215()) && this.field_25400.method_29554((class_1927)this, (class_1922)this.field_9187, (class_2338)pos, blockState, reducedStrength)) {
            touched.add(pos.method_10063());
        }
        return totalResistance;
    }
}

