/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.poi.fast_retrieval;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import me.jellysquid.mods.lithium.common.util.Collector;
import me.jellysquid.mods.lithium.common.util.Pos;
import me.jellysquid.mods.lithium.common.util.collections.ListeningLong2ObjectOpenHashMap;
import me.jellysquid.mods.lithium.common.world.interests.RegionBasedStorageSectionAccess;
import net.minecraft.class_1923;
import net.minecraft.class_4076;
import net.minecraft.class_4180;
import net.minecraft.class_4284;
import net.minecraft.class_5539;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4180.class})
public abstract class SerializingRegionBasedStorageMixin<R>
implements RegionBasedStorageSectionAccess<R> {
    @Mutable
    @Shadow
    @Final
    private Long2ObjectMap<Optional<R>> field_18692;
    @Shadow
    @Final
    protected class_5539 field_27240;
    private Long2ObjectOpenHashMap<BitSet> columns;

    @Shadow
    protected abstract Optional<R> method_19294(long var1);

    @Shadow
    protected abstract void method_19289(class_1923 var1);

    @Inject(method={"<init>(Ljava/nio/file/Path;Ljava/util/function/Function;Ljava/util/function/Function;Lcom/mojang/datafixers/DataFixer;Lnet/minecraft/datafixer/DataFixTypes;ZLnet/minecraft/world/HeightLimitView;)V"}, at={@At(value="RETURN")})
    private void init(Path directory, Function<Runnable, Codec<R>> codecFactory, Function<Runnable, R> factory, DataFixer dataFixer, class_4284 dataFixTypes, boolean dsync, class_5539 world, CallbackInfo ci) {
        this.columns = new Long2ObjectOpenHashMap();
        this.field_18692 = new ListeningLong2ObjectOpenHashMap<Optional>(this::onEntryAdded, this::onEntryRemoved);
    }

    private void onEntryRemoved(long key, Optional<R> value) {
    }

    private void onEntryAdded(long key, Optional<R> value) {
        int z;
        int y = Pos.SectionYIndex.fromSectionCoord(this.field_27240, class_4076.method_18689((long)key));
        if (y < 0 || y >= Pos.SectionYIndex.getNumYSections(this.field_27240)) {
            return;
        }
        int x = class_4076.method_18686((long)key);
        long pos = class_1923.method_8331((int)x, (int)(z = class_4076.method_18690((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags == null) {
            flags = new BitSet(Pos.SectionYIndex.getNumYSections(this.field_27240));
            this.columns.put(pos, (Object)flags);
        }
        flags.set(y, value.isPresent());
    }

    @Override
    public Stream<R> getWithinChunkColumn(int chunkX, int chunkZ) {
        BitSet flags = this.getCachedColumnInfo(chunkX, chunkZ);
        if (flags.isEmpty()) {
            return Stream.empty();
        }
        return flags.stream().map(chunkYIndex -> Pos.SectionYCoord.fromSectionIndex(this.field_27240, chunkYIndex)).mapToObj(chunkY -> ((Optional)this.field_18692.get(class_4076.method_18685((int)chunkX, (int)chunkY, (int)chunkZ))).orElse(null)).filter(Objects::nonNull);
    }

    @Override
    public boolean collectWithinChunkColumn(int chunkX, int chunkZ, Collector<R> consumer) {
        BitSet flags = this.getCachedColumnInfo(chunkX, chunkZ);
        if (flags.isEmpty()) {
            return true;
        }
        int chunkY = flags.nextSetBit(0);
        while (chunkY >= 0) {
            Object obj = ((Optional)this.field_18692.get(class_4076.method_18685((int)chunkX, (int)Pos.SectionYCoord.fromSectionIndex(this.field_27240, chunkY), (int)chunkZ))).orElse(null);
            if (obj != null && !consumer.collect(obj)) {
                return false;
            }
            chunkY = flags.nextSetBit(chunkY + 1);
        }
        return true;
    }

    private BitSet getCachedColumnInfo(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        BitSet flags = this.getColumnInfo(pos, false);
        if (flags != null) {
            return flags;
        }
        this.method_19289(new class_1923(pos));
        return this.getColumnInfo(pos, true);
    }

    private BitSet getColumnInfo(long pos, boolean required) {
        BitSet set = (BitSet)this.columns.get(pos);
        if (set == null && required) {
            throw new NullPointerException("No data is present for column: " + new class_1923(pos));
        }
        return set;
    }
}

