/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.okzoomer.utils;

import io.github.ennuil.libzoomer.api.MouseModifier;
import io.github.ennuil.libzoomer.api.TransitionMode;
import io.github.ennuil.libzoomer.api.ZoomInstance;
import io.github.ennuil.libzoomer.api.modifiers.ZoomDivisorMouseModifier;
import io.github.ennuil.libzoomer.api.transitions.SmoothTransitionMode;
import io.github.ennuil.okzoomer.config.OkZoomerConfigManager;
import io.github.ennuil.okzoomer.key_binds.ZoomKeyBinds;
import io.github.ennuil.okzoomer.packets.ZoomPackets;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.quiltmc.qsl.tag.api.QuiltTagKey;
import org.quiltmc.qsl.tag.api.TagType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ok Zoomer");
    public static final ZoomInstance ZOOMER_ZOOM = new ZoomInstance(new class_2960("okzoomer:zoom"), 4.0f, (TransitionMode)new SmoothTransitionMode(0.75f), (MouseModifier)new ZoomDivisorMouseModifier(), null);
    public static final class_6862<class_1792> ZOOM_DEPENDENCIES_TAG = QuiltTagKey.of((class_5321)class_2378.field_25108, (class_2960)new class_2960("okzoomer", "zoom_dependencies"), (TagType)TagType.CLIENT_FALLBACK);
    public static int zoomStep = 0;
    private static boolean openCommandScreen = false;

    public static final void changeZoomDivisor(boolean increase) {
        if (ZoomPackets.getDisableZoom() || ZoomPackets.getDisableZoomScrolling()) {
            return;
        }
        double zoomDivisor = OkZoomerConfigManager.configInstance.values().getZoomDivisor();
        double minimumZoomDivisor = OkZoomerConfigManager.configInstance.values().getMinimumZoomDivisor();
        double maximumZoomDivisor = OkZoomerConfigManager.configInstance.values().getMaximumZoomDivisor();
        int upperScrollStep = OkZoomerConfigManager.configInstance.values().getUpperScrollSteps();
        int lowerScrollStep = OkZoomerConfigManager.configInstance.values().getLowerScrollSteps();
        if (ZoomPackets.getForceZoomDivisors()) {
            double packetMinimumZoomDivisor = ZoomPackets.getMaximumZoomDivisor();
            double packetMaximumZoomDivisor = ZoomPackets.getMaximumZoomDivisor();
            if (packetMinimumZoomDivisor < minimumZoomDivisor) {
                minimumZoomDivisor = packetMinimumZoomDivisor;
            }
            if (packetMaximumZoomDivisor > maximumZoomDivisor) {
                maximumZoomDivisor = packetMaximumZoomDivisor;
            }
        }
        if ((zoomStep = increase ? Math.min(zoomStep + 1, upperScrollStep) : Math.max(zoomStep - 1, -lowerScrollStep)) > 0) {
            ZOOMER_ZOOM.setZoomDivisor(zoomDivisor + (maximumZoomDivisor - zoomDivisor) / (double)upperScrollStep * (double)zoomStep);
        } else if (zoomStep == 0) {
            ZOOMER_ZOOM.setZoomDivisor(zoomDivisor);
        } else {
            ZOOMER_ZOOM.setZoomDivisor(zoomDivisor + (minimumZoomDivisor - zoomDivisor) / (double)lowerScrollStep * (double)(-zoomStep));
        }
    }

    public static final void resetZoomDivisor(boolean userPrompted) {
        if (userPrompted && (ZoomPackets.getDisableZoom() || ZoomPackets.getDisableZoomScrolling())) {
            return;
        }
        ZOOMER_ZOOM.resetZoomDivisor();
        zoomStep = 0;
    }

    public static final void keepZoomStepsWithinBounds() {
        int upperScrollStep = OkZoomerConfigManager.configInstance.values().getUpperScrollSteps();
        int lowerScrollStep = OkZoomerConfigManager.configInstance.values().getLowerScrollSteps();
        zoomStep = class_3532.method_15340((int)zoomStep, (int)(-lowerScrollStep), (int)upperScrollStep);
    }

    public static final void unbindConflictingKey(class_310 client, boolean userPrompted) {
        if (ZoomKeyBinds.ZOOM_KEY.method_1427()) {
            if (client.field_1690.field_1879.method_1427()) {
                if (userPrompted) {
                    LOGGER.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding...");
                    client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_2218, (class_2561)new class_2588("toast.okzoomer.title"), (class_2561)new class_2588("toast.okzoomer.unbind_conflicting_key.success")));
                } else {
                    LOGGER.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding... This process won't be repeated until specified in the config.");
                }
                client.field_1690.field_1879.method_1422(class_3675.field_16237);
                client.field_1690.method_1640();
                class_304.method_1426();
            } else {
                LOGGER.info("[Ok Zoomer] No conflicts with the \"Save Toolbar Activator\" keybind were found!");
                if (userPrompted) {
                    client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_2218, (class_2561)new class_2588("toast.okzoomer.title"), (class_2561)new class_2588("toast.okzoomer.unbind_conflicting_key.no_conflict")));
                }
            }
        }
    }

    public static boolean shouldOpenCommandScreen() {
        return openCommandScreen;
    }

    public static void setOpenCommandScreen(boolean openCommandScreen) {
        ZoomUtils.openCommandScreen = openCommandScreen;
    }
}

