/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog;

import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5423;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import virtuoel.no_fog.api.NoFogConfig;
import virtuoel.no_fog.util.AutoConfigUtils;
import virtuoel.no_fog.util.DummyNoFogConfig;
import virtuoel.no_fog.util.FogToggleType;
import virtuoel.no_fog.util.FogToggles;
import virtuoel.no_fog.util.ModLoaderUtils;
import virtuoel.no_fog.util.ReflectionUtils;

public class NoFogClient
implements ClientModInitializer {
    public static final String MOD_ID = "no_fog";
    public static final Logger LOGGER = LogManager.getLogger((String)"no_fog");
    public static final boolean CONFIGS_LOADED = ModLoaderUtils.isModLoaded("cloth_config") || ModLoaderUtils.isModLoaded("cloth-config") || ModLoaderUtils.isModLoaded("cloth-config2");
    private static final NoFogConfig FALLBACK = new DummyNoFogConfig();
    public static final Supplier<NoFogConfig> CONFIG = !CONFIGS_LOADED ? () -> FALLBACK : AutoConfigUtils.CONFIG;
    public static final float FOG_START = -8.0f;
    public static final float FOG_END = 1000000.0f;
    private static boolean loggedError = false;

    public void onInitializeClient() {
        if (CONFIGS_LOADED) {
            AutoConfigUtils.initialize();
        }
        ReflectionUtils.init();
    }

    public static float getFogDistance(FogToggleType type, class_1297 entity, float fogDistance, boolean start) {
        return NoFogClient.isToggleEnabled(type, entity) ? fogDistance : (start ? -8.0f : 1000000.0f);
    }

    public static boolean isToggleEnabled(FogToggleType type, class_1297 entity) {
        String biomeId;
        String dimension = entity.field_6002.method_27983().method_29177().toString();
        NoFogConfig config = CONFIG.get();
        FogToggles globalToggles = config.getGlobalToggles();
        FogToggles dimensionToggles = config.getDimensionToggles().computeIfAbsent(dimension, xva$0 -> new FogToggles(xva$0));
        try {
            class_1959 biome = ReflectionUtils.getBiome(entity);
            biomeId = ReflectionUtils.getDynamicRegistry((class_5423)entity.field_6002, class_2378.field_25114).method_10221((Object)biome).toString();
        }
        catch (Throwable e) {
            if (!loggedError) {
                loggedError = true;
                LOGGER.catching(e);
            }
            return type.apply(dimensionToggles).orElse(type.apply(globalToggles).orElse(type.defaultToggle));
        }
        FogToggles biomeToggles = config.getBiomeToggles().computeIfAbsent(biomeId, xva$0 -> new FogToggles(xva$0));
        return type.apply(biomeToggles).orElse(type.apply(dimensionToggles).orElse(type.apply(globalToggles).orElse(type.defaultToggle)));
    }

    public static class_2960 id(String name) {
        return new class_2960(MOD_ID, name);
    }
}

