/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import java.util.function.Function;
import virtuoel.no_fog.util.FogToggles;
import virtuoel.no_fog.util.TriState;

public enum FogToggleType implements Function<FogToggles, TriState>
{
    WATER(t -> t.waterFog),
    LAVA(t -> t.lavaFog),
    POWDER_SNOW(t -> t.powderSnowFog),
    BLINDNESS(t -> t.blindnessFog, true),
    THICK(t -> t.thickFog),
    SKY(t -> t.skyFog, true),
    TERRAIN(t -> t.terrainFog);

    private final Function<FogToggles, TriState> delegate;
    public final boolean defaultToggle;

    private FogToggleType(Function<FogToggles, TriState> configFunc) {
        this(configFunc, false);
    }

    private FogToggleType(Function<FogToggles, TriState> configFunc, boolean defaultToggle) {
        this.delegate = configFunc;
        this.defaultToggle = defaultToggle;
    }

    @Override
    public TriState apply(FogToggles t) {
        return this.delegate.apply(t);
    }
}

