/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.network.PacketRedirection;
import qouteall.q_misc_util.MiscHelper;

public class WorldInfoSender {
    public static void init() {
        IPGlobal.postServerTickSignal.connect(() -> {
            MiscHelper.getServer().m_129905_().m_6180_("portal_send_world_info");
            if (McHelper.getServerGameTime() % 100L == 42L) {
                for (ServerPlayer player : McHelper.getCopiedPlayerList()) {
                    Set<ResourceKey<Level>> visibleDimensions = NewChunkTrackingGraph.getVisibleDimensions(player);
                    if (player.f_19853_.m_46472_() != Level.f_46428_) {
                        WorldInfoSender.sendWorldInfo(player, MiscHelper.getServer().m_129880_(Level.f_46428_));
                    }
                    MiscHelper.getServer().m_129785_().forEach(thisWorld -> {
                        if (WorldInfoSender.isNonOverworldSurfaceDimension((Level)thisWorld) && visibleDimensions.contains(thisWorld.m_46472_())) {
                            WorldInfoSender.sendWorldInfo(player, thisWorld);
                        }
                    });
                }
            }
            MiscHelper.getServer().m_129905_().m_7238_();
        });
    }

    public static void sendWorldInfo(ServerPlayer player, ServerLevel world) {
        ResourceKey remoteDimension = world.m_46472_();
        PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)remoteDimension, (Packet)new ClientboundSetTimePacket(world.m_46467_(), world.m_46468_(), world.m_46469_().m_46207_(GameRules.f_46140_)));
        if (world.m_46471_()) {
            PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)world.m_46472_(), (Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132154_, 0.0f));
        }
        PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)world.m_46472_(), (Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132160_, world.m_46722_(1.0f)));
        PacketRedirection.sendRedirectedMessage(player, (ResourceKey<Level>)world.m_46472_(), (Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132161_, world.m_46661_(1.0f)));
    }

    public static boolean isNonOverworldSurfaceDimension(Level world) {
        return world.m_6042_().f_223549_() && world.m_46472_() != Level.f_46428_;
    }
}

