/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.client.sync;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.ClientTelemetryManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEClientPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEPlayerPositionLookS2CPacket;
import qouteall.imm_ptl.core.network.IPNetworkAdapt;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.dimension.DimensionTypeSync;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPacketListener
implements IEClientPlayNetworkHandler {
    @Shadow
    private ClientLevel f_104889_;
    @Shadow
    private Minecraft f_104888_;
    @Mutable
    @Shadow
    @Final
    private Map<UUID, PlayerInfo> f_104892_;
    @Shadow
    private RegistryAccess.Frozen f_104903_;
    private boolean isReProcessingPassengerPacket;

    @Shadow
    public abstract void m_6403_(ClientboundSetPassengersPacket var1);

    @Shadow
    protected abstract void m_194248_(int var1, int var2, ClientboundLightUpdatePacketData var3);

    @Shadow
    public abstract RegistryAccess m_105152_();

    @Override
    public void ip_setWorld(ClientLevel world) {
        this.f_104889_ = world;
    }

    @Override
    public Map getPlayerListEntries() {
        return this.f_104892_;
    }

    @Override
    public void setPlayerListEntries(Map value) {
        this.f_104892_ = value;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(Minecraft client, Screen screen, Connection connection, GameProfile profile, ClientTelemetryManager telemetrySender, CallbackInfo ci) {
        this.isReProcessingPassengerPacket = false;
    }

    @Inject(method={"Lnet/minecraft/client/multiplayer/ClientPacketListener;handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="RETURN")})
    private void onOnGameJoin(ClientboundLoginPacket packet, CallbackInfo ci) {
        ClientWorldLoader.isFlatWorld = packet.f_132374_();
        DimensionTypeSync.onGameJoinPacketReceived((RegistryAccess)packet.f_132366_());
    }

    @Inject(method={"Lnet/minecraft/client/multiplayer/ClientPacketListener;handleMovePlayer(Lnet/minecraft/network/protocol/game/ClientboundPlayerPositionPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void onProcessingPositionPacket(ClientboundPlayerPositionPacket packet, CallbackInfo ci) {
        if (!IPNetworkAdapt.doesServerHasIP()) {
            return;
        }
        ResourceKey<Level> playerDimension = ((IEPlayerPositionLookS2CPacket)packet).getPlayerDimension();
        ClientLevel world = this.f_104888_.f_91073_;
        if (world != null && world.m_46472_() != playerDimension && !Minecraft.m_91087_().f_91074_.m_213877_()) {
            Helper.log(String.format("denied position packet %s %s %s %s", ((IEPlayerPositionLookS2CPacket)packet).getPlayerDimension(), packet.m_132818_(), packet.m_132821_(), packet.m_132822_()));
            ci.cancel();
        }
        IPCGlobal.clientTeleportationManager.disableTeleportFor(5);
    }

    @Inject(method={"Lnet/minecraft/client/multiplayer/ClientPacketListener;handleSetEntityPassengersPacket(Lnet/minecraft/network/protocol/game/ClientboundSetPassengersPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void onOnEntityPassengersSet(ClientboundSetPassengersPacket entityPassengersSetS2CPacket_1, CallbackInfo ci) {
        Entity entity_1 = this.f_104889_.m_6815_(entityPassengersSetS2CPacket_1.m_133286_());
        if (entity_1 == null && !this.isReProcessingPassengerPacket) {
            Helper.log("Re-processed riding packet");
            IPGlobal.clientTaskList.addTask(() -> {
                this.isReProcessingPassengerPacket = true;
                this.m_6403_(entityPassengersSetS2CPacket_1);
                this.isReProcessingPassengerPacket = false;
                return true;
            });
            ci.cancel();
        }
    }

    @Redirect(method={"Lnet/minecraft/client/multiplayer/ClientPacketListener;handleSetEntityData(Lnet/minecraft/network/protocol/game/ClientboundSetEntityDataPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getEntity(I)Lnet/minecraft/world/entity/Entity;"))
    private Entity redirectGetEntityById(ClientLevel clientWorld, int id) {
        Entity entity = clientWorld.m_6815_(id);
        if (entity == null) {
            Helper.err("missing entity for data tracking " + clientWorld + id);
        }
        return entity;
    }

    @Redirect(method={"Lnet/minecraft/client/multiplayer/ClientPacketListener;handleSetEntityMotion(Lnet/minecraft/network/protocol/game/ClientboundSetEntityMotionPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;lerpMotion(DDD)V"))
    private void redirectSetVelocityOnOnVelocityUpdate(Entity entity, double x, double y, double z) {
        if (!entity.m_6109_()) {
            entity.m_6001_(x, y, z);
        } else {
            Helper.err("wrong velocity update packet " + entity);
        }
    }

    @Inject(method={"handleSetTime"}, at={@At(value="RETURN")})
    private void onSetTime(ClientboundSetTimePacket packet, CallbackInfo ci) {
        if (ClientWorldLoader.getIsInitialized()) {
            ClientLevel currentWorld = this.f_104888_.f_91073_;
            for (ClientLevel clientWorld : ClientWorldLoader.getClientWorlds()) {
                if (clientWorld == currentWorld) continue;
                clientWorld.m_104637_(packet.m_133358_());
            }
        }
    }

    @Override
    public void portal_setRegistryManager(RegistryAccess.Frozen arg) {
        this.f_104903_ = arg;
    }
}

