/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.teleportation.ClientTeleportationManager;
import qouteall.q_misc_util.Helper;

public class RequiemCompat {
    private static boolean isRequiemPresent = false;
    private static Class class_RequiemPlayer;
    private static Class class_PossessionComponent;
    private static Method method_asPossessor;
    private static Method method_getPossessedEntity;

    public static boolean getIsRequiemPresent() {
        return isRequiemPresent;
    }

    public static void init() {
        isRequiemPresent = ModList.get().isLoaded("requiem");
        if (!isRequiemPresent) {
            return;
        }
        class_RequiemPlayer = Helper.noError(() -> Class.forName("ladysnake.requiem.api.v1.RequiemPlayer"));
        class_PossessionComponent = Helper.noError(() -> Class.forName("ladysnake.requiem.api.v1.possession.PossessionComponent"));
        method_asPossessor = Helper.noError(() -> class_RequiemPlayer.getDeclaredMethod("asPossessor", new Class[0]));
        method_getPossessedEntity = Helper.noError(() -> class_PossessionComponent.getDeclaredMethod("getPossessedEntity", new Class[0]));
    }

    public static Mob getPossessedEntity(Player player) {
        Validate.isTrue((boolean)isRequiemPresent);
        Object possessionComponent = Helper.noError(() -> method_asPossessor.invoke((Object)player, new Object[0]));
        Object possessedEntity = Helper.noError(() -> method_getPossessedEntity.invoke(possessionComponent, new Object[0]));
        return (Mob)possessedEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onPlayerTeleportedClient() {
        if (!isRequiemPresent) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Mob possessedEntity = RequiemCompat.getPossessedEntity((Player)player);
        if (possessedEntity != null && possessedEntity.f_19853_ != player.f_19853_) {
            Helper.log("Move Requiem Possessed Entity at Client");
            ClientTeleportationManager.moveClientEntityAcrossDimension((Entity)possessedEntity, (ClientLevel)player.f_19853_, player.m_20182_());
        }
    }

    public static void onPlayerTeleportedServer(ServerPlayer player) {
        if (!isRequiemPresent) {
            return;
        }
        Mob possessedEntity = RequiemCompat.getPossessedEntity((Player)player);
        if (possessedEntity != null && possessedEntity.f_19853_ != player.f_19853_) {
            Helper.log("Move Requiem Posessed Entity at Server");
            IPGlobal.serverTeleportationManager.changeEntityDimension((Entity)possessedEntity, (ResourceKey<Level>)player.f_19853_.m_46472_(), McHelper.getEyePos((Entity)player), false);
        }
    }
}

