/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class EndPortalEntity
extends Portal {
    public static EntityType<EndPortalEntity> entityType = (EntityType)IPRegistry.END_PORTAL.get();
    private EndPortalEntity clientFakedReversePortal;

    public EndPortalEntity(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
        this.renderingMergable = true;
        this.hasCrossPortalCollision = false;
    }

    public static void onEndPortalComplete(ServerLevel world, Vec3 portalCenter) {
        if (IPGlobal.endPortalMode == IPGlobal.EndPortalMode.normal) {
            EndPortalEntity.generateClassicalEndPortal(world, new Vec3(0.0, 120.0, 0.0), portalCenter);
        } else if (IPGlobal.endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            BlockPos endSpawnPos = ServerLevel.f_8562_;
            EndPortalEntity.generateClassicalEndPortal(world, Vec3.m_82512_((Vec3i)endSpawnPos).m_82520_(0.0, 1.0, 0.0), portalCenter);
        } else if (IPGlobal.endPortalMode == IPGlobal.EndPortalMode.scaledView) {
            EndPortalEntity.generateScaledViewEndPortal(world, portalCenter);
        } else {
            Helper.err("End portal mode abnormal");
        }
        EndPortalEntity.generateObsidianPlatform();
    }

    private static void generateClassicalEndPortal(ServerLevel world, Vec3 destination, Vec3 portalCenter) {
        EndPortalEntity portal = new EndPortalEntity(entityType, (Level)world);
        portal.m_6034_(portalCenter.f_82479_, portalCenter.f_82480_, portalCenter.f_82481_);
        portal.setDestination(destination);
        portal.dimensionTo = Level.f_46430_;
        portal.axisW = new Vec3(0.0, 0.0, 1.0);
        portal.axisH = new Vec3(1.0, 0.0, 0.0);
        portal.width = 3.0;
        portal.height = 3.0;
        world.m_7967_((Entity)portal);
    }

    private static void generateScaledViewEndPortal(ServerLevel world, Vec3 portalCenter) {
        ServerLevel endWorld = McHelper.getServerWorld((ResourceKey<Level>)Level.f_46430_);
        double d = 3.0;
        Vec3 viewBoxSize = new Vec3(d, 1.2, d);
        double scale = 280.0 / d;
        AABB thisSideBox = Helper.getBoxByBottomPosAndSize(portalCenter.m_82520_(0.0, 0.0, 0.0), viewBoxSize);
        AABB otherSideBox = Helper.getBoxByBottomPosAndSize(new Vec3(0.0, 0.0, 0.0), viewBoxSize.m_82490_(scale));
        for (Direction direction : Direction.values()) {
            EndPortalEntity portal = PortalManipulation.createOrthodoxPortal(entityType, world, endWorld, direction, Helper.getBoxSurface(thisSideBox, direction), Helper.getBoxSurface(otherSideBox, direction).m_82399_());
            portal.scaling = scale;
            portal.teleportChangesScale = false;
            portal.portalTag = "view_box";
            McHelper.spawnServerEntity(portal);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            this.tickClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        if (Objects.equals(this.portalTag, "view_box")) {
            Vec3 cameraPosVec;
            double dist;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (this.getNormal().f_82480_ > 0.5 && ((IEEntity)player).getCollidingPortal() == this && (dist = this.getDistanceToNearestPointInPortal(cameraPosVec = player.m_20299_(1.0f))) < 1.0) {
                double mul = dist / 2.0 + 0.1;
                player.m_20334_(player.m_20184_().f_82479_ * mul, player.m_20184_().f_82480_ * mul, player.m_20184_().f_82481_ * mul);
            }
            this.fuseView = true;
        } else if (Objects.equals(this.portalTag, "view_box_faked_reverse") && this.clientFakedReversePortal.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public void onEntityTeleportedOnServer(Entity entity) {
        super.onEntityTeleportedOnServer(entity);
        if (this.shouldAddSlowFalling(entity)) {
            int duration = 120;
            if (Objects.equals(this.portalTag, "view_box")) {
                duration = 200;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, duration, 1));
        }
        EndPortalEntity.generateObsidianPlatform();
    }

    @Override
    public void transformVelocity(Entity entity) {
    }

    @Override
    public boolean canTeleportEntity(Entity entity) {
        if (entity instanceof Arrow) {
            return false;
        }
        return super.canTeleportEntity(entity);
    }

    private boolean shouldAddSlowFalling(Entity entity) {
        if (entity instanceof LivingEntity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (player.f_8941_.m_9290_() == GameType.CREATIVE) {
                    return false;
                }
                if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42741_) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldLimitBoundingBox() {
        return false;
    }

    private static void generateObsidianPlatform() {
        ServerLevel endWorld = MiscHelper.getServer().m_129880_(Level.f_46430_);
        ServerLevel.m_8617_((ServerLevel)endWorld);
    }

    @Override
    public void onCollidingWithEntity(Entity entity) {
        if (!this.f_19853_.m_5776_() && entity instanceof ServerPlayer && IPGlobal.endPortalMode == IPGlobal.EndPortalMode.toObsidianPlatform) {
            EndPortalEntity.generateObsidianPlatform();
        }
    }
}

