/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.q_misc_util.Helper;

public class DefaultPortalAnimation {
    public TimingFunction timingFunction;
    public int durationTicks;
    public boolean inverseScale;

    public DefaultPortalAnimation(TimingFunction timingFunction, int durationTicks, boolean inverseScale) {
        this.timingFunction = timingFunction;
        this.durationTicks = durationTicks;
        this.inverseScale = inverseScale;
    }

    public static DefaultPortalAnimation createDefault() {
        return new DefaultPortalAnimation(TimingFunction.sine, 10, false);
    }

    public static DefaultPortalAnimation fromNbt(CompoundTag nbt) {
        String c = nbt.m_128461_("curve");
        TimingFunction timingFunction = TimingFunction.fromString(c);
        int durationTicks = nbt.m_128451_("durationTicks");
        boolean inverseScale = nbt.m_128471_("inverseScale");
        return new DefaultPortalAnimation(timingFunction, durationTicks, inverseScale);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startClientDefaultAnimation(Portal portal, PortalState animationStartState) {
        PortalState newState = portal.getPortalState();
        if (newState == null) {
            Helper.err("portal animation state abnormal");
            return;
        }
        if (newState.fromWorld != animationStartState.fromWorld || newState.toWorld != animationStartState.toWorld) {
            return;
        }
        ClientPortalAnimationManagement.addDefaultAnimation(portal, animationStartState, newState, this);
        portal.setPortalState(animationStartState);
    }

    public CompoundTag toNbt() {
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.m_128359_("curve", this.timingFunction.toString());
        nbtCompound.m_128405_("durationTicks", this.durationTicks);
        nbtCompound.m_128379_("inverseScale", this.inverseScale);
        return nbtCompound;
    }

    public DefaultPortalAnimation copy() {
        return new DefaultPortalAnimation(this.timingFunction, this.durationTicks, this.inverseScale);
    }
}

