/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import org.jetbrains.annotations.NotNull;

public enum TimingFunction {
    linear,
    sine,
    circle;


    @NotNull
    static TimingFunction fromString(String c) {
        TimingFunction timingFunction = switch (c) {
            case "linear" -> linear;
            case "sine" -> sine;
            case "circle" -> circle;
            default -> sine;
        };
        return timingFunction;
    }

    public double mapProgress(double progress) {
        switch (this) {
            case linear: {
                return progress;
            }
            case sine: {
                return Math.sin(progress * 1.5707963267948966);
            }
            case circle: {
                return Math.sqrt(1.0 - (1.0 - progress) * (1.0 - progress));
            }
        }
        throw new RuntimeException();
    }
}

