/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.mojang.math.Quaternion;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.SignalArged;

public class PortalGenInfo {
    public static final SignalArged<PortalGenInfo> generatedSignal = new SignalArged();
    public ResourceKey<Level> from;
    public ResourceKey<Level> to;
    public BlockPortalShape fromShape;
    public BlockPortalShape toShape;
    @Nullable
    public Quaternion rotation = null;
    public double scale = 1.0;

    public PortalGenInfo(ResourceKey<Level> from, ResourceKey<Level> to, BlockPortalShape fromShape, BlockPortalShape toShape) {
        this.from = from;
        this.to = to;
        this.fromShape = fromShape;
        this.toShape = toShape;
    }

    public PortalGenInfo(ResourceKey<Level> from, ResourceKey<Level> to, BlockPortalShape fromShape, BlockPortalShape toShape, Quaternion rotation, double scale) {
        this.from = from;
        this.to = to;
        this.fromShape = fromShape;
        this.toShape = toShape;
        this.rotation = rotation;
        this.scale = scale;
        if (rotation != null && Math.abs(1.0 - (double)rotation.m_80156_()) < 0.001) {
            this.rotation = null;
        }
        if (Math.abs(this.scale - 1.0) < 1.0E-5) {
            this.scale = 1.0;
        }
    }

    public <T extends Portal> T createTemplatePortal(EntityType<T> entityType) {
        ServerLevel fromWorld = MiscHelper.getServer().m_129880_(this.from);
        Portal portal = (Portal)entityType.m_20615_((Level)fromWorld);
        this.fromShape.initPortalPosAxisShape(portal, false);
        portal.dimensionTo = this.to;
        portal.setDestination(this.toShape.innerAreaBox.getCenterVec());
        portal.scaling = this.scale;
        portal.rotation = this.rotation;
        return (T)portal;
    }

    public <T extends BreakablePortalEntity> BreakablePortalEntity[] generateBiWayBiFacedPortal(EntityType<T> entityType) {
        ServerLevel fromWorld = MiscHelper.getServer().m_129880_(this.from);
        ServerLevel toWorld = MiscHelper.getServer().m_129880_(this.to);
        BreakablePortalEntity f1 = (BreakablePortalEntity)this.createTemplatePortal(entityType);
        BreakablePortalEntity f2 = (BreakablePortalEntity)PortalManipulation.createFlippedPortal(f1, entityType);
        BreakablePortalEntity t1 = (BreakablePortalEntity)PortalManipulation.createReversePortal(f1, entityType);
        BreakablePortalEntity t2 = (BreakablePortalEntity)PortalManipulation.createFlippedPortal(t1, entityType);
        f1.blockPortalShape = this.fromShape;
        f2.blockPortalShape = this.fromShape;
        t1.blockPortalShape = this.toShape;
        t2.blockPortalShape = this.toShape;
        f1.reversePortalId = t1.m_20148_();
        t1.reversePortalId = f1.m_20148_();
        f2.reversePortalId = t2.m_20148_();
        t2.reversePortalId = f2.m_20148_();
        PortalExtension.initializeClusterBind(f1, f2, t1, t2);
        McHelper.spawnServerEntity(f1);
        McHelper.spawnServerEntity(f2);
        McHelper.spawnServerEntity(t1);
        McHelper.spawnServerEntity(t2);
        return new BreakablePortalEntity[]{f1, f2, t1, t2};
    }

    public void generatePlaceholderBlocks() {
        MinecraftServer server = MiscHelper.getServer();
        NetherPortalGeneration.fillInPlaceHolderBlocks(server.m_129880_(this.from), this.fromShape);
        NetherPortalGeneration.fillInPlaceHolderBlocks(server.m_129880_(this.to), this.toShape);
        generatedSignal.emit(this);
    }
}

