/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;

public abstract class PortalGenTrigger {
    public static final Codec<PortalGenTrigger> triggerCodec;
    public static final Registry<Codec<? extends PortalGenTrigger>> codecRegistry;
    public static final Codec<UseItemTrigger> useItemTriggerCodec;
    public static final Codec<ThrowItemTrigger> throwItemTriggerCodec;
    public static final Codec<ConventionalDimensionChangeTrigger> conventionalDimensionChangeCodec;

    public abstract Codec<? extends PortalGenTrigger> getCodec();

    static {
        useItemTriggerCodec = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122827_.m_194605_().fieldOf("item").forGetter(o -> o.item), (App)Codec.BOOL.optionalFieldOf("consume", (Object)false).forGetter(o -> o.consume)).apply((Applicative)instance, instance.stable(UseItemTrigger::new)));
        throwItemTriggerCodec = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122827_.m_194605_().fieldOf("item").forGetter(o -> o.item)).apply((Applicative)instance, instance.stable(ThrowItemTrigger::new)));
        conventionalDimensionChangeCodec = Codec.unit(ConventionalDimensionChangeTrigger::new);
        codecRegistry = new MappedRegistry(ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("imm_ptl:custom_portal_gen_trigger")), Lifecycle.stable(), null);
        Registry.m_122965_(codecRegistry, (ResourceLocation)new ResourceLocation("imm_ptl:use_item"), useItemTriggerCodec);
        Registry.m_122965_(codecRegistry, (ResourceLocation)new ResourceLocation("imm_ptl:throw_item"), throwItemTriggerCodec);
        Registry.m_122965_(codecRegistry, (ResourceLocation)new ResourceLocation("imm_ptl:conventional_dimension_change"), (Object)ConventionalDimensionChangeTrigger.conventionalDimensionChangeCodec);
        triggerCodec = codecRegistry.m_194605_().dispatchStable(PortalGenTrigger::getCodec, Function.identity());
    }

    public static class ThrowItemTrigger
    extends PortalGenTrigger {
        public final Item item;

        public ThrowItemTrigger(Item item) {
            this.item = item;
        }

        @Override
        public Codec<? extends PortalGenTrigger> getCodec() {
            return throwItemTriggerCodec;
        }
    }

    public static class UseItemTrigger
    extends PortalGenTrigger {
        public final Item item;
        public final boolean consume;

        public UseItemTrigger(Item item, boolean consume) {
            this.item = item;
            this.consume = consume;
        }

        public boolean shouldConsume(UseOnContext context) {
            if (!this.consume) {
                return false;
            }
            Player player = context.m_43723_();
            return player == null || !player.m_7500_();
        }

        @Override
        public Codec<? extends PortalGenTrigger> getCodec() {
            return useItemTriggerCodec;
        }
    }

    public static class ConventionalDimensionChangeTrigger
    extends PortalGenTrigger {
        @Override
        public Codec<? extends PortalGenTrigger> getCodec() {
            return conventionalDimensionChangeCodec;
        }
    }
}

