/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.MiscHelper;

public class FrameSearching {
    public static <T> void startSearchingPortalFrameAsync(WorldGenRegion region, int regionRadius, BlockPos centerPoint, Predicate<BlockState> framePredicate, Function<BlockPos.MutableBlockPos, T> matchShape, Consumer<T> onFound, Runnable onNotFound) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                Object result = FrameSearching.searchPortalFrame(region, regionRadius, centerPoint, framePredicate, matchShape);
                MiscHelper.getServer().execute(() -> {
                    if (result != null) {
                        onFound.accept(result);
                    } else {
                        onNotFound.run();
                    }
                });
            }
            catch (Throwable oops) {
                oops.printStackTrace();
                onNotFound.run();
            }
        }, Util.m_183991_());
    }

    @Nullable
    public static <T> T searchPortalFrame(WorldGenRegion region, int regionRadius, BlockPos centerPoint, Predicate<BlockState> framePredicate, Function<BlockPos.MutableBlockPos, T> matchShape) {
        ArrayList<ChunkAccess> chunks = FrameSearching.getChunksFromNearToFar(region, centerPoint, regionRadius);
        int minSectionY = McHelper.getMinSectionY((LevelAccessor)region);
        int maxSectionYExclusive = McHelper.getMaxSectionYExclusive((LevelAccessor)region);
        return FrameSearching.searchPortalFrameWithYRange(framePredicate, matchShape, chunks, minSectionY, McHelper.getMinY((LevelAccessor)region), McHelper.getMaxYExclusive((LevelAccessor)region));
    }

    @Nullable
    private static <T> T searchPortalFrameWithYRange(Predicate<BlockState> framePredicate, Function<BlockPos.MutableBlockPos, T> matchShape, ArrayList<ChunkAccess> chunks, int minSectionY, int yRangeStart, int yRangeEnd) {
        BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
        for (int chunkIndex = 0; chunkIndex < chunks.size(); ++chunkIndex) {
            ChunkAccess chunk = chunks.get(chunkIndex);
            LevelChunkSection[] sectionArray = chunk.m_7103_();
            for (int ySectionIndex = 0; ySectionIndex < sectionArray.length; ++ySectionIndex) {
                int sectionY = ySectionIndex + minSectionY;
                LevelChunkSection chunkSection = sectionArray[ySectionIndex];
                if (chunkSection == null || chunkSection.m_188008_()) continue;
                int localYStart = Math.max(0, yRangeStart - sectionY * 16);
                int localYEnd = Math.min(16, yRangeEnd - sectionY * 16);
                for (int localY = localYStart; localY < localYEnd; ++localY) {
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        for (int localX = 0; localX < 16; ++localX) {
                            BlockState blockState = chunkSection.m_62982_(localX, localY, localZ);
                            if (!framePredicate.test(blockState)) continue;
                            int worldX = localX + chunk.m_7697_().m_45604_();
                            int worldY = localY + sectionY * 16;
                            int worldZ = localZ + chunk.m_7697_().m_45605_();
                            temp.m_122178_(worldX, worldY, worldZ);
                            T result = matchShape.apply(temp);
                            if (result == null) continue;
                            return result;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static ArrayList<ChunkAccess> getChunksFromNearToFar(WorldGenRegion region, BlockPos centerPoint, int regionRadius) {
        ArrayList<ChunkAccess> chunks = new ArrayList<ChunkAccess>();
        int searchedRadius = regionRadius - 1;
        int centerX = region.m_143488_().f_45578_;
        int centerZ = region.m_143488_().f_45579_;
        for (int x = centerX - searchedRadius; x <= centerX + searchedRadius; ++x) {
            for (int z = centerZ - searchedRadius; z <= centerZ + searchedRadius; ++z) {
                chunks.add(region.m_6325_(x, z));
            }
        }
        chunks.sort(Comparator.comparingDouble(chunk -> chunk.m_7697_().m_45615_().m_123331_((Vec3i)centerPoint)));
        return chunks;
    }
}

