/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEShader;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.my_util.Plane;

public class FrontClipping {
    private static final Minecraft client = Minecraft.m_91087_();
    private static double[] activeClipPlaneEquation;
    private static double[] activeClipPlaneForEntities;
    public static boolean isClippingEnabled;

    public static void disableClipping() {
        if (IPGlobal.enableClippingMechanism) {
            GL11.glDisable((int)12288);
            isClippingEnabled = false;
        }
    }

    private static void enableClipping() {
        if (IPGlobal.enableClippingMechanism) {
            GL11.glEnable((int)12288);
            isClippingEnabled = true;
        }
    }

    public static void updateInnerClipping(PoseStack matrixStack) {
        if (PortalRendering.isRendering()) {
            FrontClipping.setupInnerClipping(PortalRendering.getRenderingPortal(), false, matrixStack);
        } else {
            FrontClipping.disableClipping();
        }
    }

    public static void setupInnerClipping(PortalLike portalLike, boolean doCompensate, PoseStack matrixStack) {
        if (!IPCGlobal.useFrontClipping) {
            return;
        }
        Plane clipping = portalLike.getInnerClipping();
        if (clipping != null) {
            activeClipPlaneEquation = FrontClipping.getClipEquationInner(doCompensate, clipping.pos, clipping.normal);
            activeClipPlaneForEntities = FrontClipping.transformClipEquation(activeClipPlaneEquation, matrixStack);
            FrontClipping.enableClipping();
        } else {
            activeClipPlaneEquation = null;
            FrontClipping.disableClipping();
        }
    }

    private static double[] transformClipEquation(double[] equation, PoseStack matrixStack) {
        Vector4f eq = new Vector4f((float)equation[0], (float)equation[1], (float)equation[2], (float)equation[3]);
        Matrix4f m = matrixStack.m_85850_().m_85861_().m_27658_();
        m.m_27657_();
        m.m_27659_();
        eq.m_123607_(m);
        return new double[]{eq.m_123601_(), eq.m_123615_(), eq.m_123616_(), eq.m_123617_()};
    }

    private static double[] getClipEquationInner(boolean doCompensate, Vec3 clippingPoint, Vec3 clippingDirection) {
        Vec3 cameraPos = CHelper.getCurrentCameraPos();
        Vec3 planeNormal = clippingDirection;
        double correction = doCompensate ? clippingPoint.m_82546_(cameraPos).m_82526_(clippingDirection) / 150.0 : 0.0;
        Vec3 portalPos = clippingPoint.m_82546_(planeNormal.m_82490_(correction)).m_82546_(cameraPos);
        double c = planeNormal.m_82490_(-1.0).m_82526_(portalPos);
        return new double[]{planeNormal.f_82479_, planeNormal.f_82480_, planeNormal.f_82481_, c};
    }

    public static void setupOuterClipping(PoseStack matrixStack, PortalLike portalLike) {
        if (!IPCGlobal.useFrontClipping) {
            return;
        }
        if (portalLike instanceof Portal) {
            activeClipPlaneEquation = FrontClipping.getClipEquationOuter((Portal)portalLike);
            activeClipPlaneForEntities = FrontClipping.transformClipEquation(activeClipPlaneEquation, matrixStack);
            FrontClipping.enableClipping();
        } else {
            activeClipPlaneEquation = null;
            FrontClipping.disableClipping();
        }
    }

    private static double[] getClipEquationOuter(Portal portal) {
        Vec3 planeNormal = portal.getNormal();
        Vec3 portalPos = portal.getOriginPos().m_82546_(FrontClipping.client.f_91063_.m_109153_().m_90583_());
        double c = planeNormal.m_82490_(-1.0).m_82526_(portalPos);
        return new double[]{planeNormal.f_82479_, planeNormal.f_82480_, planeNormal.f_82481_, c};
    }

    public static double[] getActiveClipPlaneEquation() {
        return activeClipPlaneEquation;
    }

    public static double[] getActiveClipPlaneEquationForEntities() {
        return activeClipPlaneForEntities;
    }

    public static void updateClippingEquationUniformForCurrentShader(boolean isRenderingEntities) {
        if (!IPGlobal.enableClippingMechanism) {
            return;
        }
        ShaderInstance shader = RenderSystem.m_157196_();
        if (shader == null) {
            return;
        }
        Uniform clippingEquationUniform = ((IEShader)shader).ip_getClippingEquationUniform();
        if (clippingEquationUniform != null) {
            if (isClippingEnabled) {
                double[] equation = isRenderingEntities ? activeClipPlaneForEntities : activeClipPlaneEquation;
                clippingEquationUniform.m_5805_((float)equation[0], (float)equation[1], (float)equation[2], (float)equation[3]);
            } else {
                clippingEquationUniform.m_5805_(0.0f, 0.0f, 0.0f, 1.0f);
            }
        }
    }

    public static void unsetClippingUniform() {
        if (!IPGlobal.enableClippingMechanism) {
            return;
        }
        ShaderInstance shader = RenderSystem.m_157196_();
        if (shader == null) {
            return;
        }
        Uniform clippingEquationUniform = ((IEShader)shader).ip_getClippingEquationUniform();
        if (clippingEquationUniform != null) {
            clippingEquationUniform.m_5805_(0.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    static {
        isClippingEnabled = false;
    }
}

