/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationClient;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.ducks.IEParticleManager;
import qouteall.imm_ptl.core.ducks.IEWorldRenderer;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.render.VisibleSectionDiscovery;
import qouteall.imm_ptl.core.render.context_management.DimensionRenderHelper;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.my_util.LimitedLogger;

@OnlyIn(value=Dist.CLIENT)
public class MyGameRenderer {
    public static final Minecraft client = Minecraft.m_91087_();
    private static final LimitedLogger limitedLogger = new LimitedLogger(10);
    private static Stack<RenderBuffers> secondaryRenderBuffers = new Stack();
    private static int usingRenderBuffersObjectNum = 0;
    public static int vanillaTerrainSetupOverride = 0;
    public static boolean enablePortalCaveCulling = true;

    public static void init() {
        IPGlobal.clientCleanupSignal.connect(() -> secondaryRenderBuffers.clear());
    }

    @Nullable
    private static RenderBuffers acquireRenderBuffersObject() {
        if (usingRenderBuffersObjectNum >= 2) {
            return null;
        }
        --usingRenderBuffersObjectNum;
        if (secondaryRenderBuffers.isEmpty()) {
            return new RenderBuffers();
        }
        return secondaryRenderBuffers.pop();
    }

    private static void returnRenderBuffersObject(RenderBuffers renderBuffers) {
        ++usingRenderBuffersObjectNum;
        secondaryRenderBuffers.push(renderBuffers);
    }

    public static void renderWorldNew(WorldRenderInfo worldRenderInfo, Consumer<Runnable> invokeWrapper) {
        WorldRenderInfo.pushRenderInfo(worldRenderInfo);
        MyGameRenderer.switchAndRenderTheWorld(worldRenderInfo.world, worldRenderInfo.cameraPos, worldRenderInfo.cameraPos, invokeWrapper, worldRenderInfo.renderDistance, worldRenderInfo.doRenderHand);
        WorldRenderInfo.popRenderInfo();
    }

    private static void switchAndRenderTheWorld(ClientLevel newWorld, Vec3 thisTickCameraPos, Vec3 lastTickCameraPos, Consumer<Runnable> invokeWrapper, int renderDistance, boolean doRenderHand) {
        if (!enablePortalCaveCulling) {
            MyGameRenderer.client.f_90980_ = false;
        }
        if (!PortalRendering.shouldEnableSodiumCaveCulling()) {
            MyGameRenderer.client.f_90980_ = false;
        }
        Entity cameraEntity = MyGameRenderer.client.f_91075_;
        Vec3 oldEyePos = McHelper.getEyePos(cameraEntity);
        Vec3 oldLastTickEyePos = McHelper.getLastTickEyePos(cameraEntity);
        ResourceKey oldEntityDimension = cameraEntity.f_19853_.m_46472_();
        ClientLevel oldEntityWorld = (ClientLevel)cameraEntity.f_19853_;
        ResourceKey newDimension = newWorld.m_46472_();
        McHelper.setEyePos(cameraEntity, thisTickCameraPos, lastTickCameraPos);
        cameraEntity.f_19853_ = newWorld;
        LevelRenderer worldRenderer = ClientWorldLoader.getWorldRenderer((ResourceKey<Level>)newDimension);
        CHelper.checkGlError();
        float tickDelta = RenderStates.tickDelta;
        IEGameRenderer ieGameRenderer = (IEGameRenderer)MyGameRenderer.client.f_91063_;
        DimensionRenderHelper helper = ClientWorldLoader.getDimensionRenderHelper((ResourceKey<Level>)newDimension);
        Camera newCamera = new Camera();
        LevelRenderer oldWorldRenderer = MyGameRenderer.client.f_91060_;
        LightTexture oldLightmap = MyGameRenderer.client.f_91063_.m_109154_();
        boolean oldNoClip = MyGameRenderer.client.f_91074_.f_19794_;
        boolean oldDoRenderHand = ieGameRenderer.getDoRenderHand();
        ObjectArrayList<LevelRenderer.RenderChunkInfo> oldChunkInfoList = ((IEWorldRenderer)oldWorldRenderer).portal_getChunkInfoList();
        HitResult oldCrosshairTarget = MyGameRenderer.client.f_91077_;
        Camera oldCamera = MyGameRenderer.client.f_91063_.m_109153_();
        PostChain oldTransparencyShader = ((IEWorldRenderer)worldRenderer).portal_getTransparencyShader();
        RenderBuffers oldRenderBuffers = ((IEWorldRenderer)worldRenderer).ip_getRenderBuffers();
        RenderBuffers oldClientRenderBuffers = client.m_91269_();
        Frustum oldFrustum = ((IEWorldRenderer)worldRenderer).portal_getFrustum();
        Matrix4f oldProjectionMatrix = RenderSystem.m_157192_();
        ObjectArrayList<LevelRenderer.RenderChunkInfo> newChunkInfoList = VisibleSectionDiscovery.takeList();
        ((IEWorldRenderer)oldWorldRenderer).portal_setChunkInfoList(newChunkInfoList);
        Object irisPipeline = IrisInterface.invoker.getPipeline(worldRenderer);
        ((IEMinecraftClient)client).setWorldRenderer(worldRenderer);
        MyGameRenderer.client.f_91073_ = newWorld;
        ieGameRenderer.setLightmapTextureManager(helper.lightmapTexture);
        MyGameRenderer.client.m_167982_().f_112248_ = newWorld;
        MyGameRenderer.client.f_91074_.f_19794_ = true;
        MyGameRenderer.client.f_91063_.m_172736_(doRenderHand);
        FogRendererContext.swappingManager.pushSwapping((ResourceKey<Level>)newDimension);
        ((IEParticleManager)MyGameRenderer.client.f_91061_).ip_setWorld(newWorld);
        if (BlockManipulationClient.remotePointedDim == newDimension) {
            MyGameRenderer.client.f_91077_ = BlockManipulationClient.remoteHitResult;
        }
        ieGameRenderer.setCamera(newCamera);
        RenderBuffers newRenderBuffers = null;
        if (IPGlobal.useSecondaryEntityVertexConsumer) {
            newRenderBuffers = MyGameRenderer.acquireRenderBuffersObject();
            ((IEWorldRenderer)worldRenderer).ip_setRenderBuffers(newRenderBuffers);
            ((IEMinecraftClient)client).ip_setRenderBuffers(newRenderBuffers);
        }
        Object newSodiumContext = SodiumInterface.invoker.createNewContext(renderDistance);
        SodiumInterface.invoker.switchContextWithCurrentWorldRenderer(newSodiumContext);
        ((IEWorldRenderer)worldRenderer).portal_setTransparencyShader(null);
        IrisInterface.invoker.setPipeline(worldRenderer, null);
        if (!RenderStates.isDimensionRendered((ResourceKey<Level>)newDimension)) {
            helper.lightmapTexture.m_109881_(0.0f);
        }
        try {
            invokeWrapper.accept(() -> {
                client.m_91307_().m_6180_("render_portal_content");
                MyGameRenderer.client.f_91063_.m_109089_(tickDelta, Util.m_137569_(), new PoseStack());
                client.m_91307_().m_7238_();
            });
        }
        catch (Throwable e) {
            limitedLogger.invoke(e::printStackTrace);
        }
        SodiumInterface.invoker.switchContextWithCurrentWorldRenderer(newSodiumContext);
        ((IEMinecraftClient)client).setWorldRenderer(oldWorldRenderer);
        MyGameRenderer.client.f_91073_ = oldEntityWorld;
        ieGameRenderer.setLightmapTextureManager(oldLightmap);
        MyGameRenderer.client.m_167982_().f_112248_ = oldEntityWorld;
        MyGameRenderer.client.f_91074_.f_19794_ = oldNoClip;
        MyGameRenderer.client.f_91063_.m_172736_(oldDoRenderHand);
        ((IEParticleManager)MyGameRenderer.client.f_91061_).ip_setWorld(oldEntityWorld);
        MyGameRenderer.client.f_91077_ = oldCrosshairTarget;
        ieGameRenderer.setCamera(oldCamera);
        ((IEWorldRenderer)worldRenderer).portal_setTransparencyShader(oldTransparencyShader);
        FogRendererContext.swappingManager.popSwapping();
        ((IEWorldRenderer)oldWorldRenderer).portal_setChunkInfoList(oldChunkInfoList);
        VisibleSectionDiscovery.returnList(newChunkInfoList);
        ((IEWorldRenderer)worldRenderer).ip_setRenderBuffers(oldRenderBuffers);
        ((IEMinecraftClient)client).ip_setRenderBuffers(oldClientRenderBuffers);
        if (newRenderBuffers != null) {
            MyGameRenderer.returnRenderBuffersObject(newRenderBuffers);
        }
        ((IEWorldRenderer)worldRenderer).portal_setFrustum(oldFrustum);
        RenderSystem.m_157425_((Matrix4f)oldProjectionMatrix);
        IrisInterface.invoker.setPipeline(worldRenderer, irisPipeline);
        client.m_91290_().m_114408_((Level)MyGameRenderer.client.f_91073_, oldCamera, MyGameRenderer.client.f_91076_);
        CHelper.checkGlError();
        cameraEntity.f_19853_ = oldEntityWorld;
        McHelper.setEyePos(cameraEntity, oldEyePos, oldLastTickEyePos);
        MyGameRenderer.client.f_90980_ = true;
    }

    public static void renderPlayerItself(Runnable doRenderEntity) {
        EntityRenderDispatcher entityRenderDispatcher = ((IEWorldRenderer)MyGameRenderer.client.f_91060_).ip_getEntityRenderDispatcher();
        PlayerInfo playerListEntry = CHelper.getClientPlayerListEntry();
        GameType originalGameMode = RenderStates.originalGameMode;
        Entity player = MyGameRenderer.client.f_91075_;
        assert (player != null);
        Vec3 oldPos = player.m_20182_();
        Vec3 oldLastTickPos = McHelper.lastTickPosOf(player);
        GameType oldGameMode = playerListEntry.m_105325_();
        McHelper.setPosAndLastTickPos(player, RenderStates.originalPlayerPos, RenderStates.originalPlayerLastTickPos);
        doRenderEntity.run();
        McHelper.setPosAndLastTickPos(player, oldPos, oldLastTickPos);
    }

    @IPVanillaCopy
    public static void resetFogState() {
        Camera camera = MyGameRenderer.client.f_91063_.m_109153_();
        float g = MyGameRenderer.client.f_91063_.m_109152_();
        Vec3 cameraPos = camera.m_90583_();
        double d = cameraPos.m_7096_();
        double e = cameraPos.m_7098_();
        double f = cameraPos.m_7094_();
        boolean bl2 = MyGameRenderer.client.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)d), Mth.m_14107_((double)e)) || MyGameRenderer.client.f_91065_.m_93090_().m_93715_();
        boolean bl3 = MyGameRenderer.client.f_91073_.m_104583_().m_5781_(Mth.m_14107_((double)d), Mth.m_14107_((double)e)) || MyGameRenderer.client.f_91065_.m_93090_().m_93715_();
        FogRenderer.m_234172_((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)Math.max(g, 32.0f), (boolean)bl3, (float)RenderStates.tickDelta);
        FogRenderer.m_109036_();
    }

    public static void updateFogColor() {
        FogRenderer.m_109018_((Camera)MyGameRenderer.client.f_91063_.m_109153_(), (float)RenderStates.tickDelta, (ClientLevel)MyGameRenderer.client.f_91073_, (int)MyGameRenderer.client.f_91066_.m_193772_(), (float)MyGameRenderer.client.f_91063_.m_109131_(RenderStates.tickDelta));
    }

    public static void resetDiffuseLighting(PoseStack matrixStack) {
        if (MyGameRenderer.client.f_91073_.m_104583_().m_108885_()) {
            Lighting.m_84925_((Matrix4f)matrixStack.m_85850_().m_85861_());
        } else {
            Lighting.m_84928_((Matrix4f)matrixStack.m_85850_().m_85861_());
        }
    }
}

