/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.QueryManager;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

public class RendererDebug
extends PortalRenderer {
    @Override
    public void onBeforeTranslucentRendering(PoseStack matrixStack) {
        this.renderPortals(matrixStack);
    }

    @Override
    public void onAfterTranslucentRendering(PoseStack matrixStack) {
    }

    @Override
    public void onHandRenderingEnded(PoseStack matrixStack) {
    }

    @Override
    public void prepareRendering() {
    }

    @Override
    public void finishRendering() {
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    @Override
    public boolean replaceFrameBufferClearing() {
        return false;
    }

    protected void doRenderPortal(PortalLike portal, PoseStack matrixStack) {
        if (RenderStates.getRenderedPortalNum() != 0) {
            return;
        }
        if (!this.testShouldRenderPortal(portal, matrixStack)) {
            return;
        }
        PortalRendering.pushPortalLayer(portal);
        GlStateManager.m_84318_((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GlStateManager.m_84121_((double)1.0);
        GlStateManager.m_84266_((int)16640, (boolean)Minecraft.f_91002_);
        GL11.glDisable((int)2960);
        this.renderPortalContent(portal);
        PortalRendering.popPortalLayer();
    }

    private boolean testShouldRenderPortal(PortalLike portal, PoseStack matrixStack) {
        return QueryManager.renderAndGetDoesAnySamplePass(() -> ViewAreaRenderer.renderPortalArea(portal, Vec3.f_82478_, matrixStack.m_85850_().m_85861_(), RenderSystem.m_157192_(), true, true, true));
    }

    protected void renderPortals(PoseStack matrixStack) {
        List<PortalLike> portalsToRender = this.getPortalsToRender(matrixStack);
        for (PortalLike portal : portalsToRender) {
            this.doRenderPortal(portal, matrixStack);
        }
    }
}

