/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import org.apache.commons.lang3.Validate;
import qouteall.q_misc_util.MiscNetworking;
import qouteall.q_misc_util.forge.networking.Message;
import qouteall.q_misc_util.forge.networking.Remote_StC;

public class ImplRemoteProcedureCall {
    public static final Gson gson;
    private static final ConcurrentHashMap<String, Method> methodCache;
    private static final ImmutableMap<Class, BiConsumer<FriendlyByteBuf, Object>> serializerMap;
    private static final ImmutableMap<Type, Function<FriendlyByteBuf, Object>> deserializerMap;
    private static final JsonParser jsonParser;

    private static Object deserializeByCodec(FriendlyByteBuf buf, Codec codec) {
        String jsonString = ImplRemoteProcedureCall.readStringNonClientOnly(buf);
        JsonElement jsonElement = jsonParser.parse(jsonString);
        return codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, e -> {
            throw new RuntimeException(e.toString());
        });
    }

    private static String readStringNonClientOnly(FriendlyByteBuf buf) {
        return buf.m_130136_(Short.MAX_VALUE);
    }

    private static Object deserialize(FriendlyByteBuf buf, Type type) {
        Function deserializer = (Function)deserializerMap.get((Object)type);
        if (deserializer == null) {
            String json = ImplRemoteProcedureCall.readStringNonClientOnly(buf);
            return gson.fromJson(json, type);
        }
        return deserializer.apply(buf);
    }

    private static void serialize(FriendlyByteBuf buf, Object object) {
        BiConsumer serializer = (BiConsumer)serializerMap.get(object.getClass());
        if (serializer == null) {
            serializer = serializerMap.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(object.getClass())).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        if (serializer == null) {
            String json = gson.toJson(object);
            buf.m_130070_(json);
            return;
        }
        serializer.accept(buf, object);
    }

    private static void serializeByCodec(FriendlyByteBuf buf, Codec codec, Object object) {
        JsonElement result = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(false, e -> {
            throw new RuntimeException(e.toString());
        });
        String jsonString = gson.toJson(result);
        buf.m_130070_(jsonString);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ServerboundCustomPayloadPacket createC2SPacket(String methodPath, Object ... arguments) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        ImplRemoteProcedureCall.serializeStringWithArguments(methodPath, arguments, buf);
        return new ServerboundCustomPayloadPacket(MiscNetworking.id_ctsRemote, buf);
    }

    public static Packet createS2CPacket(String methodPath, Object ... arguments) {
        return Message.INSTANCE.toVanillaPacket((Object)new Remote_StC(methodPath, arguments), NetworkDirection.PLAY_TO_CLIENT);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Runnable clientReadPacketAndGetHandler(FriendlyByteBuf buf) {
        String methodPath = ImplRemoteProcedureCall.readStringNonClientOnly(buf);
        Method method = ImplRemoteProcedureCall.getMethodByPath(methodPath);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Object[] arguments = new Object[genericParameterTypes.length];
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            Object obj;
            Type parameterType = genericParameterTypes[i];
            arguments[i] = obj = ImplRemoteProcedureCall.deserialize(buf, parameterType);
        }
        return () -> {
            try {
                method.invoke(null, arguments);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static Runnable serverReadPacketAndGetHandler(ServerPlayer player, FriendlyByteBuf buf) {
        String methodPath = ImplRemoteProcedureCall.readStringNonClientOnly(buf);
        Method method = ImplRemoteProcedureCall.getMethodByPath(methodPath);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Object[] arguments = new Object[genericParameterTypes.length];
        arguments[0] = player;
        for (int i = 1; i < genericParameterTypes.length; ++i) {
            Object obj;
            Type parameterType = genericParameterTypes[i];
            arguments[i] = obj = ImplRemoteProcedureCall.deserialize(buf, parameterType);
        }
        return () -> {
            try {
                method.invoke(null, arguments);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static void serializeStringWithArguments(String methodPath, Object[] arguments, FriendlyByteBuf buf) {
        buf.m_130070_(methodPath);
        for (Object argument : arguments) {
            ImplRemoteProcedureCall.serialize(buf, argument);
        }
    }

    private static Method getMethodByPath(String methodPath) {
        Method result = methodCache.get(methodPath);
        if (result != null) {
            return result;
        }
        Method method = ImplRemoteProcedureCall.findMethodByPath(methodPath);
        Validate.notNull((Object)method);
        methodCache.put(methodPath, method);
        return method;
    }

    private static Method findMethodByPath(String methodPath) {
        Class<?> aClass;
        int lastDotIndex = methodPath.lastIndexOf(46);
        Validate.isTrue((lastDotIndex != -1 ? 1 : 0) != 0);
        String classPath = methodPath.substring(0, lastDotIndex);
        String methodName = methodPath.substring(lastDotIndex + 1);
        if (!classPath.contains("RemoteCallable")) {
            throw new RuntimeException("The class path must contain \"RemoteCallable\"");
        }
        try {
            aClass = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            int dotIndex = classPath.lastIndexOf(46);
            if (dotIndex != -1) {
                String newClassPath = classPath.substring(0, dotIndex) + "$" + classPath.substring(dotIndex + 1);
                try {
                    aClass = Class.forName(newClassPath);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException("Cannot find class " + classPath, e);
                }
            }
            throw new RuntimeException("Cannot find class " + classPath, e);
        }
        Method method = Arrays.stream(aClass.getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find method " + methodPath + " . If it's a private method, make it public."));
        return method;
    }

    static {
        methodCache = new ConcurrentHashMap();
        jsonParser = new JsonParser();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gson = gsonBuilder.create();
        serializerMap = ImmutableMap.builder().put(ResourceLocation.class, (buf, o) -> buf.m_130085_((ResourceLocation)o)).put(ResourceKey.class, (buf, o) -> buf.m_130085_(((ResourceKey)o).m_135782_())).put(BlockPos.class, (buf, o) -> buf.m_130064_((BlockPos)o)).put(Vec3.class, (buf, o) -> {
            Vec3 vec = (Vec3)o;
            buf.writeDouble(vec.f_82479_);
            buf.writeDouble(vec.f_82480_);
            buf.writeDouble(vec.f_82481_);
        }).put(UUID.class, (buf, o) -> buf.m_130077_((UUID)o)).put(Block.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, Registry.f_122824_.m_194605_(), o)).put(Item.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, Registry.f_122827_.m_194605_(), o)).put(BlockState.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, BlockState.f_61039_, o)).put(ItemStack.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, ItemStack.f_41582_, o)).put(CompoundTag.class, (buf, o) -> buf.m_130079_((CompoundTag)o)).put(Component.class, (buf, o) -> buf.m_130083_((Component)o)).build();
        deserializerMap = ImmutableMap.builder().put(ResourceLocation.class, buf -> buf.m_130281_()).put((Object)new TypeToken<ResourceKey<Level>>(){}.getType(), buf -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_())).put((Object)new TypeToken<ResourceKey<Biome>>(){}.getType(), buf -> ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)buf.m_130281_())).put(BlockPos.class, buf -> buf.m_130135_()).put(Vec3.class, buf -> new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble())).put(UUID.class, buf -> buf.m_130259_()).put(Block.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, Registry.f_122824_.m_194605_())).put(Item.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, Registry.f_122827_.m_194605_())).put(BlockState.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, BlockState.f_61039_)).put(ItemStack.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, ItemStack.f_41582_)).put(CompoundTag.class, buf -> buf.m_130260_()).put(Component.class, buf -> buf.m_130238_()).build();
    }
}

