/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimensionIdRecord;

public class DimId {
    private static final boolean useIntegerId = false;

    public static void writeWorldId(FriendlyByteBuf buf, ResourceKey<Level> dimension, boolean isClient) {
        buf.m_130085_(dimension.m_135782_());
    }

    public static ResourceKey<Level> readWorldId(FriendlyByteBuf buf, boolean isClient) {
        if (isClient && MiscHelper.isDedicatedServer()) {
            throw new IllegalStateException("oops");
        }
        ResourceLocation identifier = buf.m_130281_();
        return DimId.idToKey(identifier);
    }

    public static ResourceKey<Level> idToKey(ResourceLocation identifier) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)identifier);
    }

    public static ResourceKey<Level> idToKey(String str) {
        return DimId.idToKey(new ResourceLocation(str));
    }

    public static void putWorldId(CompoundTag tag, String tagName, ResourceKey<Level> dim) {
        tag.m_128359_(tagName, dim.m_135782_().toString());
    }

    public static ResourceKey<Level> getWorldId(CompoundTag tag, String tagName, boolean isClient) {
        Tag term = tag.m_128423_(tagName);
        if (term instanceof IntTag) {
            int intId;
            DimensionIdRecord record = isClient ? DimensionIdRecord.clientRecord : DimensionIdRecord.serverRecord;
            ResourceKey<Level> result = record.getDimFromIntOptional(intId = ((IntTag)term).m_7047_());
            if (result == null) {
                Helper.err("unknown dimension id " + intId);
                return Level.f_46428_;
            }
            return result;
        }
        if (term instanceof StringTag) {
            String id = ((StringTag)term).m_7916_();
            return DimId.idToKey(id);
        }
        throw new RuntimeException("Invalid Dimension Record " + term);
    }
}

