/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import qouteall.q_misc_util.Helper;

public class IntBox {
    public final BlockPos l;
    public final BlockPos h;

    public IntBox(BlockPos l, BlockPos h) {
        this.l = Helper.min(l, h);
        this.h = Helper.max(l, h);
    }

    @Deprecated
    public static IntBox getBoxByBasePointAndSize(BlockPos areaSize, BlockPos blockPos) {
        return IntBox.fromBasePointAndSize(blockPos, areaSize);
    }

    public static IntBox fromBasePointAndSize(BlockPos blockPos, BlockPos areaSize) {
        return new IntBox(blockPos, blockPos.m_121955_((Vec3i)areaSize).m_7918_(-1, -1, -1));
    }

    public IntBox expandOrShrink(Vec3i offset) {
        return new IntBox(this.l.m_121996_(offset), this.h.m_121955_(offset));
    }

    public IntBox getExpanded(Direction.Axis axis, int n) {
        return this.expandOrShrink((Vec3i)Helper.scale(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).m_122436_(), n));
    }

    public IntBox getExpanded(Direction direction, int n) {
        if (direction.m_122421_() == Direction.AxisDirection.POSITIVE) {
            return new IntBox(this.l, this.h.m_121955_((Vec3i)Helper.scale(direction.m_122436_(), n)));
        }
        return new IntBox(this.l.m_121955_((Vec3i)Helper.scale(direction.m_122436_(), n)), this.h);
    }

    public Stream<BlockPos> stream() {
        return IntStream.range(this.l.m_123341_(), this.h.m_123341_() + 1).boxed().flatMap(x -> IntStream.range(this.l.m_123342_(), this.h.m_123342_() + 1).boxed().flatMap(y -> IntStream.range(this.l.m_123343_(), this.h.m_123343_() + 1).boxed().map(z -> new BlockPos(x.intValue(), y.intValue(), z.intValue()))));
    }

    public Stream<BlockPos> fastStream() {
        return BlockPos.m_121990_((BlockPos)this.l, (BlockPos)this.h);
    }

    public BlockPos getSize() {
        return this.h.m_7918_(1, 1, 1).m_121996_((Vec3i)this.l);
    }

    public IntBox getSurfaceLayer(Direction.Axis axis, Direction.AxisDirection axisDirection) {
        if (axisDirection == Direction.AxisDirection.NEGATIVE) {
            IntBox result = new IntBox(this.l, new BlockPos((axis == Direction.Axis.X ? this.l : this.h).m_123341_(), (axis == Direction.Axis.Y ? this.l : this.h).m_123342_(), (axis == Direction.Axis.Z ? this.l : this.h).m_123343_()));
            return result;
        }
        IntBox result = new IntBox(new BlockPos((axis == Direction.Axis.X ? this.h : this.l).m_123341_(), (axis == Direction.Axis.Y ? this.h : this.l).m_123342_(), (axis == Direction.Axis.Z ? this.h : this.l).m_123343_()), this.h);
        return result;
    }

    public IntBox getSurfaceLayer(Direction facing) {
        return this.getSurfaceLayer(facing.m_122434_(), facing.m_122421_());
    }

    @Nullable
    public static IntBox getIntersect(IntBox a, IntBox b) {
        BlockPos l = Helper.max(a.l, b.l);
        BlockPos h = Helper.min(a.h, b.h);
        if (l.m_123341_() > h.m_123341_()) {
            return null;
        }
        if (l.m_123342_() > h.m_123342_()) {
            return null;
        }
        if (l.m_123343_() > h.m_123343_()) {
            return null;
        }
        return new IntBox(l, h);
    }

    public IntBox map(Function<BlockPos, BlockPos> func1, Function<BlockPos, BlockPos> func2) {
        return new IntBox(func1.apply(this.l), func2.apply(this.h));
    }

    public BlockPos getCenter() {
        return Helper.divide((Vec3i)this.l.m_121955_((Vec3i)this.h), 2);
    }

    public Vec3 getCenterVec() {
        return new Vec3((double)(this.l.m_123341_() + this.h.m_123341_() + 1) / 2.0, (double)(this.l.m_123342_() + this.h.m_123342_() + 1) / 2.0, (double)(this.l.m_123343_() + this.h.m_123343_() + 1) / 2.0);
    }

    public IntBox getAdjusted(int dxa, int dya, int dza, int dxb, int dyb, int dzb) {
        return new IntBox(this.l.m_7918_(dxa, dya, dza), this.h.m_7918_(dxb, dyb, dzb));
    }

    public Stream<BlockPos> forSixSurfaces(Function<Stream<IntBox>, Stream<IntBox>> mapper) {
        IntBox[] array = new IntBox[]{this.getSurfaceLayer(Direction.DOWN), this.getSurfaceLayer(Direction.NORTH).getAdjusted(0, 1, 0, 0, 0, 0), this.getSurfaceLayer(Direction.SOUTH).getAdjusted(0, 1, 0, 0, 0, 0), this.getSurfaceLayer(Direction.WEST).getAdjusted(0, 1, 1, 0, 0, -1), this.getSurfaceLayer(Direction.EAST).getAdjusted(0, 1, 1, 0, 0, -1), this.getSurfaceLayer(Direction.UP).getAdjusted(1, 0, 1, -1, 0, -1)};
        return mapper.apply(Arrays.stream(array).filter(intBox -> true)).flatMap(IntBox::stream);
    }

    public IntBox getMoved(Vec3i offset) {
        return new IntBox(this.l.m_121955_(offset), this.h.m_121955_(offset));
    }

    public static IntBox getContainingBox(IntBox box1, IntBox box2) {
        return new IntBox(Helper.min(box1.l, box2.l), Helper.max(box1.h, box2.h));
    }

    public IntBox getSubBoxInCenter(BlockPos subBoxSize) {
        BlockPos thisSize = this.getSize();
        Validate.isTrue((thisSize.m_123341_() >= subBoxSize.m_123341_() ? 1 : 0) != 0);
        Validate.isTrue((thisSize.m_123342_() >= subBoxSize.m_123342_() ? 1 : 0) != 0);
        Validate.isTrue((thisSize.m_123343_() >= subBoxSize.m_123343_() ? 1 : 0) != 0);
        return IntBox.getBoxByBasePointAndSize(subBoxSize, Helper.divide((Vec3i)thisSize.m_121996_((Vec3i)subBoxSize), 2).m_121955_((Vec3i)this.l));
    }

    public BlockPos[] getEightVertices() {
        return new BlockPos[]{new BlockPos(this.l.m_123341_(), this.l.m_123342_(), this.l.m_123343_()), new BlockPos(this.l.m_123341_(), this.l.m_123342_(), this.h.m_123343_()), new BlockPos(this.l.m_123341_(), this.h.m_123342_(), this.l.m_123343_()), new BlockPos(this.l.m_123341_(), this.h.m_123342_(), this.h.m_123343_()), new BlockPos(this.h.m_123341_(), this.l.m_123342_(), this.l.m_123343_()), new BlockPos(this.h.m_123341_(), this.l.m_123342_(), this.h.m_123343_()), new BlockPos(this.h.m_123341_(), this.h.m_123342_(), this.l.m_123343_()), new BlockPos(this.h.m_123341_(), this.h.m_123342_(), this.h.m_123343_())};
    }

    public AABB toRealNumberBox() {
        return new AABB((double)this.l.m_123341_(), (double)this.l.m_123342_(), (double)this.l.m_123343_(), (double)(this.h.m_123341_() + 1), (double)(this.h.m_123342_() + 1), (double)(this.h.m_123343_() + 1));
    }

    public IntBox getExpanded(BlockPos newPoint) {
        return new IntBox(Helper.min(this.l, newPoint), Helper.max(this.h, newPoint));
    }

    public boolean contains(BlockPos pos) {
        return pos.m_123341_() >= this.l.m_123341_() && pos.m_123341_() <= this.h.m_123341_() && pos.m_123342_() >= this.l.m_123342_() && pos.m_123342_() <= this.h.m_123342_() && pos.m_123343_() >= this.l.m_123343_() && pos.m_123343_() <= this.h.m_123343_();
    }

    public BlockPos selectCoordinateFromBox(boolean high) {
        return high ? this.h : this.l;
    }

    public IntBox[] get12Edges() {
        return new IntBox[]{new IntBox(this.selectCoordinateFromBox(false, false, false), this.selectCoordinateFromBox(false, false, true)), new IntBox(this.selectCoordinateFromBox(false, true, false), this.selectCoordinateFromBox(false, true, true)), new IntBox(this.selectCoordinateFromBox(true, false, false), this.selectCoordinateFromBox(true, false, true)), new IntBox(this.selectCoordinateFromBox(true, true, false), this.selectCoordinateFromBox(true, true, true)), new IntBox(this.selectCoordinateFromBox(false, false, false), this.selectCoordinateFromBox(false, true, false)), new IntBox(this.selectCoordinateFromBox(false, false, true), this.selectCoordinateFromBox(false, true, true)), new IntBox(this.selectCoordinateFromBox(true, false, false), this.selectCoordinateFromBox(true, true, false)), new IntBox(this.selectCoordinateFromBox(true, false, true), this.selectCoordinateFromBox(true, true, true)), new IntBox(this.selectCoordinateFromBox(false, false, false), this.selectCoordinateFromBox(true, false, false)), new IntBox(this.selectCoordinateFromBox(false, false, true), this.selectCoordinateFromBox(true, false, true)), new IntBox(this.selectCoordinateFromBox(false, true, false), this.selectCoordinateFromBox(true, true, false)), new IntBox(this.selectCoordinateFromBox(false, true, true), this.selectCoordinateFromBox(true, true, true))};
    }

    public BlockPos selectCoordinateFromBox(boolean xUp, boolean yUp, boolean zUp) {
        return new BlockPos(this.selectCoordinateFromBox(xUp).m_123341_(), this.selectCoordinateFromBox(yUp).m_123342_(), this.selectCoordinateFromBox(zUp).m_123343_());
    }

    public String toString() {
        return String.format("(%d %d %d)-(%d %d %d)", this.l.m_123341_(), this.l.m_123342_(), this.l.m_123343_(), this.h.m_123341_(), this.h.m_123342_(), this.h.m_123343_());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntBox intBox = (IntBox)o;
        return this.l.equals((Object)intBox.l) && this.h.equals((Object)intBox.h);
    }

    public int hashCode() {
        return Objects.hash(this.l, this.h);
    }
}

