/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.yabn;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.teamresourceful.resourcefullib.common.codecs.yabn.YabnArrayBuilder;
import com.teamresourceful.resourcefullib.common.codecs.yabn.YabnObjectMapLike;
import com.teamresourceful.resourcefullib.common.codecs.yabn.YabnRecordBuilder;
import com.teamresourceful.resourcefullib.common.yabn.YabnCompressor;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnArray;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnElement;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnObject;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnPrimitive;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.BooleanContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.ByteContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.DoubleContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.FloatContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.IntContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.LongContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.NullContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.NumberPrimitiveContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.PrimitiveContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.ShortContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.StringContents;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class YabnOps
implements DynamicOps<YabnElement> {
    public static final YabnOps INSTANCE = new YabnOps(false);
    public static final YabnOps COMPRESSED = new YabnOps(true);
    private final boolean compressed;

    protected YabnOps(boolean compressed) {
        this.compressed = compressed;
    }

    public YabnElement empty() {
        return NullContents.NULL;
    }

    public <U> U convertTo(DynamicOps<U> outOps, YabnElement input) {
        if (input instanceof YabnObject) {
            return (U)this.convertMap(outOps, input);
        }
        if (input instanceof YabnArray) {
            return (U)this.convertList(outOps, input);
        }
        if (this.compressed) {
            input = YabnCompressor.compress(input);
        }
        if (input instanceof YabnPrimitive) {
            YabnPrimitive primitive = (YabnPrimitive)input;
            PrimitiveContents contents = primitive.contents();
            if (contents instanceof StringContents) {
                StringContents stringContents = (StringContents)contents;
                return (U)outOps.createString(stringContents.value());
            }
            if (contents instanceof BooleanContents) {
                BooleanContents booleanContents = (BooleanContents)contents;
                return (U)outOps.createBoolean(booleanContents.value());
            }
            if (contents instanceof NullContents) {
                return (U)outOps.empty();
            }
            if (contents instanceof ByteContents) {
                ByteContents byteContents = (ByteContents)contents;
                return (U)outOps.createByte(byteContents.value());
            }
            if (contents instanceof ShortContents) {
                ShortContents shortContents = (ShortContents)contents;
                return (U)outOps.createShort(shortContents.value());
            }
            if (contents instanceof IntContents) {
                IntContents intContents = (IntContents)contents;
                return (U)outOps.createInt(intContents.value());
            }
            if (contents instanceof LongContents) {
                LongContents longContents = (LongContents)contents;
                return (U)outOps.createLong(longContents.value());
            }
            if (contents instanceof DoubleContents) {
                DoubleContents doubleContents = (DoubleContents)contents;
                return (U)outOps.createDouble(doubleContents.value());
            }
            if (contents instanceof FloatContents) {
                FloatContents floatContents = (FloatContents)contents;
                return (U)outOps.createFloat(floatContents.value());
            }
            throw new IllegalStateException("Unknown primitive contents: " + contents);
        }
        throw new IllegalArgumentException("Unknown type: " + input.getClass());
    }

    public DataResult<Number> getNumberValue(YabnElement input) {
        if (input instanceof YabnPrimitive) {
            YabnPrimitive primitive = (YabnPrimitive)input;
            PrimitiveContents contents = primitive.contents();
            if (contents instanceof NumberPrimitiveContents) {
                NumberPrimitiveContents num = (NumberPrimitiveContents)contents;
                return DataResult.success((Object)num.getValue());
            }
            if (contents instanceof BooleanContents) {
                BooleanContents bool = (BooleanContents)contents;
                return DataResult.success((Object)(bool.value() ? 1 : 0));
            }
            if (this.compressed && contents instanceof StringContents) {
                StringContents str = (StringContents)contents;
                try {
                    return DataResult.success((Object)Integer.parseInt(str.value()));
                }
                catch (NumberFormatException e) {
                    return DataResult.error((String)("Not a number: " + e + " " + input));
                }
            }
        }
        return DataResult.error((String)("Not a number: " + input));
    }

    public YabnElement createNumeric(Number i) {
        BigDecimal value = new BigDecimal(i.toString());
        try {
            return YabnCompressor.compressNonFloatingNumber(value.longValueExact());
        }
        catch (ArithmeticException e) {
            return YabnCompressor.compressFloatingNumber(value.doubleValue());
        }
    }

    public DataResult<Boolean> getBooleanValue(YabnElement input) {
        if (input instanceof YabnPrimitive) {
            YabnPrimitive primitive = (YabnPrimitive)input;
            PrimitiveContents contents = primitive.contents();
            if (contents instanceof BooleanContents) {
                BooleanContents bool = (BooleanContents)contents;
                return DataResult.success((Object)bool.value());
            }
            if (contents instanceof NumberPrimitiveContents) {
                NumberPrimitiveContents num = (NumberPrimitiveContents)contents;
                return DataResult.success((Object)(num.getAsByte() != 0 ? 1 : 0));
            }
        }
        return DataResult.error((String)("Not a boolean: " + input));
    }

    public YabnElement createBoolean(boolean value) {
        return YabnPrimitive.ofBoolean(value);
    }

    public DataResult<String> getStringValue(YabnElement input) {
        if (input instanceof YabnPrimitive) {
            YabnPrimitive primitive = (YabnPrimitive)input;
            PrimitiveContents primitiveContents = primitive.contents();
            if (primitiveContents instanceof StringContents) {
                StringContents contents = (StringContents)primitiveContents;
                return DataResult.success((Object)contents.value());
            }
            if (this.compressed && (primitiveContents = primitive.contents()) instanceof NumberPrimitiveContents) {
                NumberPrimitiveContents contents = (NumberPrimitiveContents)primitiveContents;
                return DataResult.success((Object)contents.getValue().toString());
            }
        }
        return DataResult.error((String)("Not a string: " + input));
    }

    public YabnElement createString(String value) {
        return YabnPrimitive.ofString(value);
    }

    public DataResult<YabnElement> mergeToList(YabnElement list, YabnElement value) {
        return this.mergeToList(list, List.of(value));
    }

    public DataResult<YabnElement> mergeToList(YabnElement list, List<YabnElement> values) {
        if (!(list instanceof YabnArray) && list != this.empty()) {
            return DataResult.error((String)("Not a list: " + list));
        }
        YabnArray array = new YabnArray();
        if (list instanceof YabnArray) {
            YabnArray oldArray = (YabnArray)list;
            oldArray.elements().forEach(array::add);
        }
        values.forEach(array::add);
        return DataResult.success((Object)array);
    }

    public DataResult<YabnElement> mergeToMap(YabnElement map, YabnElement key, YabnElement value) {
        YabnPrimitive primitive;
        if (!(map instanceof YabnObject) && map != this.empty()) {
            return DataResult.error((String)("Not a map: " + map), (Object)map);
        }
        if (!(key instanceof YabnPrimitive) || (primitive = (YabnPrimitive)key).isNull() || !(primitive.contents() instanceof StringContents) && !this.compressed) {
            return DataResult.error((String)("key is not a string: " + key), (Object)map);
        }
        YabnObject object = new YabnObject();
        if (map instanceof YabnObject) {
            YabnObject oldObject = (YabnObject)map;
            oldObject.elements().forEach(object::put);
        }
        object.elements().put(YabnOps.getAsString(primitive), value);
        return DataResult.success((Object)object);
    }

    public DataResult<YabnElement> mergeToMap(YabnElement map, MapLike<YabnElement> values) {
        if (!(map instanceof YabnObject) && map != this.empty()) {
            return DataResult.error((String)("Not a map: " + map), (Object)map);
        }
        YabnObject object = new YabnObject();
        if (map instanceof YabnObject) {
            YabnObject oldObject = (YabnObject)map;
            oldObject.elements().forEach(object::put);
        }
        ArrayList missed = Lists.newArrayList();
        values.entries().forEach(entry -> {
            YabnPrimitive primitive;
            YabnElement key = (YabnElement)entry.getFirst();
            if (!(key instanceof YabnPrimitive) || (primitive = (YabnPrimitive)key).isNull() || !(primitive.contents() instanceof StringContents) && !this.compressed) {
                missed.add(key);
                return;
            }
            object.put(YabnOps.getAsString(primitive), (YabnElement)entry.getSecond());
        });
        return !missed.isEmpty() ? DataResult.error((String)("some keys are not strings: " + missed), (Object)object) : DataResult.success((Object)object);
    }

    public DataResult<Stream<Pair<YabnElement, YabnElement>>> getMapValues(YabnElement input) {
        if (input instanceof YabnObject) {
            YabnObject object = (YabnObject)input;
            Stream<Pair> output = object.elements().entrySet().stream().map(entry -> Pair.of((Object)this.createString((String)entry.getKey()), (Object)((YabnElement)entry.getValue()).getOrNull()));
            return DataResult.success(output);
        }
        return DataResult.error((String)("Not a YABN Object: " + input));
    }

    public DataResult<Consumer<BiConsumer<YabnElement, YabnElement>>> getMapEntries(YabnElement input) {
        if (input instanceof YabnObject) {
            YabnObject object = (YabnObject)input;
            return DataResult.success(c -> object.elements().forEach((key, value) -> c.accept(this.createString((String)key), value.getOrNull())));
        }
        return DataResult.error((String)("Not a YABN Object: " + input));
    }

    public DataResult<MapLike<YabnElement>> getMap(YabnElement input) {
        DataResult dataResult;
        if (input instanceof YabnObject) {
            YabnObject object = (YabnObject)input;
            dataResult = DataResult.success((Object)new YabnObjectMapLike(object));
        } else {
            dataResult = DataResult.error((String)("Not a YABN Object: " + input));
        }
        return dataResult;
    }

    public YabnElement createMap(Stream<Pair<YabnElement, YabnElement>> map) {
        YabnObject object = new YabnObject();
        map.forEach(p -> object.put((String)this.getStringValue((YabnElement)p.getFirst()).result().get(), (YabnElement)p.getSecond()));
        return object;
    }

    public DataResult<Stream<YabnElement>> getStream(YabnElement input) {
        if (input instanceof YabnArray) {
            YabnArray array = (YabnArray)input;
            return DataResult.success(array.elements().stream().map(YabnElement::getOrNull));
        }
        return DataResult.error((String)("Not a YABN Array: " + input));
    }

    public DataResult<Consumer<Consumer<YabnElement>>> getList(YabnElement input) {
        if (input instanceof YabnArray) {
            YabnArray array = (YabnArray)input;
            return DataResult.success(c -> array.elements().forEach(e -> c.accept(e.getOrNull())));
        }
        return DataResult.error((String)("Not a YABN Array: " + input));
    }

    public YabnElement createList(Stream<YabnElement> input) {
        YabnArray array = new YabnArray();
        input.forEach(array::add);
        return array;
    }

    public YabnElement remove(YabnElement input, String key) {
        if (input instanceof YabnObject) {
            YabnObject object = (YabnObject)input;
            object.elements().remove(key);
        }
        return input;
    }

    public String toString() {
        return "YABN";
    }

    public ListBuilder<YabnElement> listBuilder() {
        return new YabnArrayBuilder();
    }

    public boolean compressMaps() {
        return this.compressed;
    }

    public RecordBuilder<YabnElement> mapBuilder() {
        return new YabnRecordBuilder(this);
    }

    public static String getAsString(YabnPrimitive primitive) {
        PrimitiveContents contents = primitive.contents();
        if (contents instanceof StringContents) {
            StringContents stringContents = (StringContents)contents;
            return stringContents.value();
        }
        if (contents instanceof NumberPrimitiveContents) {
            NumberPrimitiveContents numberContents = (NumberPrimitiveContents)contents;
            return numberContents.getValue().toString();
        }
        if (contents instanceof BooleanContents) {
            BooleanContents booleanContents = (BooleanContents)contents;
            return booleanContents.value() ? "true" : "false";
        }
        return null;
    }
}

