/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.yabn.base.primitives;

import com.teamresourceful.resourcefullib.common.yabn.base.YabnType;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.PrimitiveContents;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.ArrayUtils;

public record StringContents(String value) implements PrimitiveContents
{
    public StringContents {
        if (value.contains("\u0000")) {
            throw new IllegalArgumentException("String cannot contain null character.");
        }
    }

    @Override
    public YabnType getId() {
        return this.value.isEmpty() ? YabnType.EMPTY_STRING : YabnType.STRING;
    }

    @Override
    public byte[] toData() {
        if (this.value.isEmpty()) {
            return new byte[0];
        }
        return ArrayUtils.add((byte[])this.value.getBytes(StandardCharsets.UTF_8), (byte)0);
    }
}

