/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.mesh;

import com.google.common.base.Preconditions;
import link.infra.indium.renderer.ReforgiumRenderer;
import link.infra.indium.renderer.RenderMaterialImpl;
import link.infra.indium.renderer.helper.NormalHelper;
import link.infra.indium.renderer.helper.TextureHelper;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.QuadViewImpl;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;

public abstract class MutableQuadViewImpl
extends QuadViewImpl
implements QuadEmitter {
    private TextureAtlasSprite cachedSprite;

    public final void begin(int[] data, int baseIndex) {
        this.data = data;
        this.baseIndex = baseIndex;
        this.clear();
    }

    public void clear() {
        System.arraycopy(EncodingFormat.EMPTY, 0, this.data, this.baseIndex, EncodingFormat.TOTAL_STRIDE);
        this.isGeometryInvalid = true;
        this.nominalFace = null;
        this.normalFlags(0);
        this.tag(0);
        this.colorIndex(-1);
        this.cullFace(null);
        this.material(ReforgiumRenderer.MATERIAL_STANDARD);
        this.cachedSprite(null);
    }

    @Override
    public final void load() {
        super.load();
        this.cachedSprite(null);
    }

    @Override
    public final MutableQuadViewImpl material(RenderMaterial material) {
        if (material == null) {
            material = ReforgiumRenderer.MATERIAL_STANDARD;
        }
        this.data[this.baseIndex + 0] = EncodingFormat.material(this.data[this.baseIndex + 0], (RenderMaterialImpl.Value)material);
        return this;
    }

    @Override
    public final MutableQuadViewImpl cullFace(Direction face) {
        this.data[this.baseIndex + 0] = EncodingFormat.cullFace(this.data[this.baseIndex + 0], face);
        this.nominalFace(face);
        return this;
    }

    @Override
    public final MutableQuadViewImpl nominalFace(Direction face) {
        this.nominalFace = face;
        return this;
    }

    @Override
    public final MutableQuadViewImpl colorIndex(int colorIndex) {
        this.data[this.baseIndex + 1] = colorIndex;
        return this;
    }

    @Override
    public final MutableQuadViewImpl tag(int tag) {
        this.data[this.baseIndex + 2] = tag;
        return this;
    }

    @Override
    @Deprecated
    public final MutableQuadViewImpl fromVanilla(int[] quadData, int startIndex, boolean isItem) {
        System.arraycopy(quadData, startIndex, this.data, this.baseIndex + 3, EncodingFormat.QUAD_STRIDE);
        this.isGeometryInvalid = true;
        this.cachedSprite(null);
        return this;
    }

    @Override
    public final MutableQuadViewImpl fromVanilla(BakedQuad quad, RenderMaterial material, Direction cullFace) {
        System.arraycopy(quad.m_111303_(), 0, this.data, this.baseIndex + 3, EncodingFormat.QUAD_STRIDE);
        this.data[this.baseIndex + 0] = EncodingFormat.cullFace(0, cullFace);
        this.nominalFace(quad.m_111306_());
        this.colorIndex(quad.m_111305_());
        this.material(material);
        this.tag(0);
        this.shade(quad.m_111307_());
        this.isGeometryInvalid = true;
        this.cachedSprite(quad.m_173410_());
        return this;
    }

    @Override
    public MutableQuadViewImpl pos(int vertexIndex, float x, float y, float z) {
        int index = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X;
        this.data[index] = Float.floatToRawIntBits(x);
        this.data[index + 1] = Float.floatToRawIntBits(y);
        this.data[index + 2] = Float.floatToRawIntBits(z);
        this.isGeometryInvalid = true;
        return this;
    }

    protected void normalFlags(int flags) {
        this.data[this.baseIndex + 0] = EncodingFormat.normalFlags(this.data[this.baseIndex + 0], flags);
    }

    @Override
    public MutableQuadViewImpl normal(int vertexIndex, float x, float y, float z) {
        this.normalFlags(this.normalFlags() | 1 << vertexIndex);
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = NormalHelper.packNormal(x, y, z, 0.0f);
        return this;
    }

    public final void populateMissingNormals() {
        int normalFlags = this.normalFlags();
        if (normalFlags == 15) {
            return;
        }
        int packedFaceNormal = NormalHelper.packNormal(this.faceNormal(), 0.0f);
        for (int v = 0; v < 4; ++v) {
            if ((normalFlags & 1 << v) != 0) continue;
            this.data[this.baseIndex + v * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = packedFaceNormal;
        }
        this.normalFlags(15);
    }

    @Override
    public MutableQuadViewImpl lightmap(int vertexIndex, int lightmap) {
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_LIGHTMAP] = lightmap;
        return this;
    }

    @Override
    public MutableQuadViewImpl spriteColor(int vertexIndex, int spriteIndex, int color) {
        Preconditions.checkArgument((spriteIndex == 0 ? 1 : 0) != 0, (String)"Unsupported sprite index: %s", (int)spriteIndex);
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_COLOR] = color;
        return this;
    }

    @Override
    public MutableQuadViewImpl sprite(int vertexIndex, int spriteIndex, float u, float v) {
        Preconditions.checkArgument((spriteIndex == 0 ? 1 : 0) != 0, (String)"Unsupported sprite index: %s", (int)spriteIndex);
        int i = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U;
        this.data[i] = Float.floatToRawIntBits(u);
        this.data[i + 1] = Float.floatToRawIntBits(v);
        this.cachedSprite = null;
        return this;
    }

    @Override
    public MutableQuadViewImpl spriteBake(int spriteIndex, TextureAtlasSprite sprite, int bakeFlags) {
        Preconditions.checkArgument((spriteIndex == 0 ? 1 : 0) != 0, (String)"Unsupported sprite index: %s", (int)spriteIndex);
        TextureHelper.bakeSprite(this, spriteIndex, sprite, bakeFlags);
        this.cachedSprite(sprite);
        return this;
    }

    public TextureAtlasSprite cachedSprite() {
        return this.cachedSprite;
    }

    public void cachedSprite(TextureAtlasSprite cachedSprite) {
        this.cachedSprite = cachedSprite;
    }
}

