/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import link.infra.indium.renderer.RenderMaterialImpl;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.helper.ColorHelper;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class BaseQuadRenderer {
    protected final QuadBufferer bufferer;
    protected final BlockRenderInfo blockInfo;
    protected final AoCalculator aoCalc;
    protected final RenderContext.QuadTransform transform;
    private final BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();

    BaseQuadRenderer(QuadBufferer bufferer, BlockRenderInfo blockInfo, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        this.bufferer = bufferer;
        this.blockInfo = blockInfo;
        this.aoCalc = aoCalc;
        this.transform = transform;
    }

    protected void renderQuad(MutableQuadViewImpl quad, boolean isVanilla) {
        if (!this.transform.transform(quad)) {
            return;
        }
        if (!this.blockInfo.shouldDrawFace(quad.cullFace())) {
            return;
        }
        this.tessellateQuad(quad, 0, isVanilla);
    }

    private void tessellateQuad(MutableQuadViewImpl quad, int textureIndex, boolean isVanilla) {
        RenderMaterialImpl.Value mat = quad.material();
        int colorIndex = mat.disableColorIndex(textureIndex) ? -1 : quad.colorIndex();
        RenderType renderLayer = this.blockInfo.effectiveRenderLayer(mat.blendMode(textureIndex));
        if (this.blockInfo.defaultAo && !mat.disableAo(textureIndex)) {
            this.aoCalc.compute(quad, isVanilla);
            if (mat.emissive(textureIndex)) {
                this.tessellateSmoothEmissive(quad, renderLayer, colorIndex);
            } else {
                this.tessellateSmooth(quad, renderLayer, colorIndex);
            }
        } else if (mat.emissive(textureIndex)) {
            this.tessellateFlatEmissive(quad, renderLayer, colorIndex);
        } else {
            this.tessellateFlat(quad, renderLayer, colorIndex);
        }
    }

    private void colorizeQuad(MutableQuadViewImpl q, int blockColorIndex) {
        if (blockColorIndex == -1) {
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(q.spriteColor(i, 0)));
            }
        } else {
            int blockColor = this.blockInfo.blockColor(blockColorIndex);
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(ColorHelper.multiplyColor(blockColor, q.spriteColor(i, 0))));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, RenderType renderLayer) {
        this.bufferer.bufferQuad(quad, renderLayer);
    }

    protected void tessellateSmooth(MutableQuadViewImpl q, RenderType renderLayer, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), this.aoCalc.ao[i]));
            q.lightmap(i, ColorHelper.maxBrightness(q.lightmap(i), this.aoCalc.light[i]));
        }
        this.bufferQuad(q, renderLayer);
    }

    protected void tessellateSmoothEmissive(MutableQuadViewImpl q, RenderType renderLayer, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), this.aoCalc.ao[i]));
            q.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(q, renderLayer);
    }

    protected void tessellateFlat(MutableQuadViewImpl quad, RenderType renderLayer, int blockColorIndex) {
        this.colorizeQuad(quad, blockColorIndex);
        this.shadeFlatQuad(quad);
        int brightness = this.flatBrightness(quad, this.blockInfo.blockState, this.blockInfo.blockPos);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), brightness));
        }
        this.bufferQuad(quad, renderLayer);
    }

    protected void tessellateFlatEmissive(MutableQuadViewImpl quad, RenderType renderLayer, int blockColorIndex) {
        this.colorizeQuad(quad, blockColorIndex);
        this.shadeFlatQuad(quad);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(quad, renderLayer);
    }

    int flatBrightness(MutableQuadViewImpl quad, BlockState blockState, BlockPos pos) {
        this.mpos.m_122190_((Vec3i)pos);
        if (quad.cullFace() != null) {
            this.mpos.m_122173_(quad.cullFace());
        } else {
            int flags = quad.geometryFlags();
            if ((flags & 4) != 0 || (flags & 2) != 0 && blockState.m_60838_((BlockGetter)this.blockInfo.blockView, pos)) {
                this.mpos.m_122173_(quad.lightFace());
            }
        }
        return LevelRenderer.m_109537_((BlockAndTintGetter)this.blockInfo.blockView, (BlockState)blockState, (BlockPos)this.mpos);
    }

    private void shadeFlatQuad(MutableQuadViewImpl quad) {
        block3: {
            block2: {
                if ((quad.geometryFlags() & 2) != 0 && !quad.hasVertexNormals()) break block2;
                float faceShade = this.blockInfo.blockView.m_7717_(quad.lightFace(), quad.hasShade());
                for (int i = 0; i < 4; ++i) {
                    quad.spriteColor(i, 0, ColorHelper.multiplyRGB(quad.spriteColor(i, 0), this.vertexShade(quad, i, faceShade)));
                }
                break block3;
            }
            float diffuseShade = this.blockInfo.blockView.m_7717_(quad.lightFace(), quad.hasShade());
            if (diffuseShade == 1.0f) break block3;
            for (int i = 0; i < 4; ++i) {
                quad.spriteColor(i, 0, ColorHelper.multiplyRGB(quad.spriteColor(i, 0), diffuseShade));
            }
        }
    }

    private float vertexShade(MutableQuadViewImpl quad, int vertexIndex, float faceShade) {
        return quad.hasNormal(vertexIndex) ? this.normalShade(quad.normalX(vertexIndex), quad.normalY(vertexIndex), quad.normalZ(vertexIndex), quad.hasShade()) : faceShade;
    }

    private float normalShade(float normalX, float normalY, float normalZ, boolean hasShade) {
        float sum = 0.0f;
        float div = 0.0f;
        if (normalX > 0.0f) {
            sum += normalX * this.blockInfo.blockView.m_7717_(Direction.EAST, hasShade);
            div += normalX;
        } else if (normalX < 0.0f) {
            sum += -normalX * this.blockInfo.blockView.m_7717_(Direction.WEST, hasShade);
            div -= normalX;
        }
        if (normalY > 0.0f) {
            sum += normalY * this.blockInfo.blockView.m_7717_(Direction.UP, hasShade);
            div += normalY;
        } else if (normalY < 0.0f) {
            sum += -normalY * this.blockInfo.blockView.m_7717_(Direction.DOWN, hasShade);
            div -= normalY;
        }
        if (normalZ > 0.0f) {
            sum += normalZ * this.blockInfo.blockView.m_7717_(Direction.SOUTH, hasShade);
            div += normalZ;
        } else if (normalZ < 0.0f) {
            sum += -normalZ * this.blockInfo.blockView.m_7717_(Direction.NORTH, hasShade);
            div -= normalZ;
        }
        return sum / div;
    }

    protected static interface QuadBufferer {
        public void bufferQuad(MutableQuadViewImpl var1, RenderType var2);
    }
}

