/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FluidFilterLogic {
    private final List<FluidStack> fluidFilters;
    private final ItemStack upgrade;
    private final Consumer<ItemStack> saveHandler;
    private boolean noFilter = true;

    public FluidFilterLogic(int filterSlots, ItemStack upgrade, Consumer<ItemStack> saveHandler) {
        this.fluidFilters = NonNullList.m_122780_((int)filterSlots, (Object)FluidStack.EMPTY);
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.deserializeFluidFilters();
        this.updateNoFilter();
    }

    private void deserializeFluidFilters() {
        NBTHelper.getTagValue(this.upgrade, "", "fluidFilters", (c, n1) -> c.m_128437_(n1, 10)).ifPresent(listNbt -> {
            int i = 0;
            for (Tag elementNbt : listNbt) {
                FluidStack value = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)elementNbt));
                if (value != null) {
                    this.fluidFilters.set(i, value);
                }
                if (++i < this.fluidFilters.size()) continue;
                break;
            }
        });
    }

    private void updateNoFilter() {
        this.noFilter = true;
        for (FluidStack fluidFilter : this.fluidFilters) {
            if (fluidFilter.isEmpty()) continue;
            this.noFilter = false;
            return;
        }
    }

    public boolean fluidMatches(FluidStack fluid) {
        return this.noFilter || this.matchesFluidFilter(fluid);
    }

    private boolean matchesFluidFilter(FluidStack fluid) {
        for (FluidStack fluidFilter : this.fluidFilters) {
            if (!fluidFilter.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    private void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public void setFluid(int index, FluidStack fluid) {
        this.fluidFilters.set(index, fluid.copy());
        this.serializeFluidFilters();
        this.updateNoFilter();
        this.save();
    }

    public FluidStack getFluid(int index) {
        return this.fluidFilters.get(index);
    }

    public int getNumberOfFluidFilters() {
        return this.fluidFilters.size();
    }

    private void serializeFluidFilters() {
        ListTag fluids = new ListTag();
        this.fluidFilters.forEach(f -> fluids.add((Object)f.writeToNBT(new CompoundTag())));
        this.upgrade.m_41784_().m_128365_("fluidFilters", (Tag)fluids);
    }
}

