/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class PumpUpgradeWrapper
extends UpgradeWrapperBase<PumpUpgradeWrapper, PumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DID_NOTHING_COOLDOWN_TIME = 40;
    private static final int HAND_INTERACTION_COOLDOWN_TIME = 3;
    private static final int WORLD_INTERACTION_COOLDOWN_TIME = 20;
    private static final int FLUID_HANDLER_INTERACTION_COOLDOWN_TIME = 20;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private static final int PUMP_IN_WORLD_RANGE = 4;
    private static final int PUMP_IN_WORLD_RANGE_SQR = 16;
    private long lastHandActionTime = -1L;
    private final FluidFilterLogic fluidFilterLogic;
    private final PumpUpgradeConfig pumpUpgradeConfig = ((PumpUpgradeItem)this.upgradeItem).getPumpUpgradeConfig();

    protected PumpUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.fluidFilterLogic = new FluidFilterLogic((Integer)this.pumpUpgradeConfig.filterSlots.get(), upgrade, upgradeSaveHandler);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        this.setCooldown(world, this.storageWrapper.getFluidHandler().map(storageFluidHandler -> this.tick((IFluidHandlerItem)storageFluidHandler, entity, world, pos)).orElse(40));
    }

    private int tick(IFluidHandlerItem storageFluidHandler, @Nullable LivingEntity entity, Level level, BlockPos pos) {
        if (entity == null) {
            Optional<Integer> newCooldown = this.handleInWorldInteractions(storageFluidHandler, level, pos);
            if (newCooldown.isPresent()) {
                return newCooldown.get();
            }
        } else {
            Player player;
            if (this.shouldInteractWithHand() && entity instanceof Player && this.handleFluidContainerInHands(player = (Player)entity, (IFluidHandler)storageFluidHandler)) {
                this.lastHandActionTime = level.m_46467_();
                return 3;
            }
            Optional<Integer> newCooldown = this.handleInWorldInteractions(storageFluidHandler, level, pos);
            if (newCooldown.isPresent()) {
                return newCooldown.get();
            }
        }
        return this.lastHandActionTime + 30L > level.m_46467_() ? 3 : 40;
    }

    private Optional<Integer> handleInWorldInteractions(IFluidHandlerItem storageFluidHandler, Level world, BlockPos pos) {
        Optional<Integer> newCooldown;
        if (this.shouldInteractWithHand() && this.handleFluidContainersInHandsOfNearbyPlayers(world, pos, (IFluidHandler)storageFluidHandler)) {
            this.lastHandActionTime = world.m_46467_();
            return Optional.of(3);
        }
        if (this.shouldInteractWithWorld() && (newCooldown = this.interactWithWorld(world, pos, (IFluidHandler)storageFluidHandler)).isPresent()) {
            return newCooldown;
        }
        return this.interactWithAttachedFluidHandlers(world, pos, (IFluidHandler)storageFluidHandler);
    }

    private Optional<Integer> interactWithAttachedFluidHandlers(Level world, BlockPos pos, IFluidHandler storageFluidHandler) {
        for (Direction dir : Direction.values()) {
            boolean successful = WorldHelper.getBlockEntity((BlockGetter)world, pos.m_121955_(dir.m_122436_())).map(te -> te.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_()).map(fluidHandler -> {
                if (this.isInput()) {
                    return this.fillFromFluidHandler((IFluidHandler)fluidHandler, storageFluidHandler, this.getMaxInOut());
                }
                return this.fillFluidHandler((IFluidHandler)fluidHandler, storageFluidHandler, this.getMaxInOut());
            }).orElse(false)).orElse(false);
            if (!successful) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private int getMaxInOut() {
        return Math.max(1000, (Integer)this.pumpUpgradeConfig.maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows() * this.getAdjustedStackMultiplier(this.storageWrapper));
    }

    public int getAdjustedStackMultiplier(IStorageWrapper storageWrapper) {
        return 1 + (int)((Double)this.pumpUpgradeConfig.stackMultiplierRatio.get() * (double)(storageWrapper.getInventoryHandler().getStackSizeMultiplier() - 1));
    }

    private Optional<Integer> interactWithWorld(Level world, BlockPos pos, IFluidHandler storageFluidHandler) {
        if (this.isInput()) {
            return this.fillFromBlockInRange(world, pos, storageFluidHandler);
        }
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = pos.m_121955_(dir.m_122436_());
            if (!this.placeFluidInWorld(world, storageFluidHandler, dir, offsetPos)) continue;
            return Optional.of(20);
        }
        return Optional.empty();
    }

    private boolean placeFluidInWorld(Level world, IFluidHandler storageFluidHandler, Direction dir, BlockPos offsetPos) {
        if (dir != Direction.UP) {
            for (int tank = 0; tank < storageFluidHandler.getTanks(); ++tank) {
                FluidStack tankFluid = storageFluidHandler.getFluidInTank(tank);
                if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid) || !this.isValidForFluidPlacement(world, offsetPos) || !FluidUtil.tryPlaceFluid(null, (Level)world, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)offsetPos, (IFluidHandler)storageFluidHandler, (FluidStack)tankFluid)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidForFluidPlacement(Level world, BlockPos offsetPos) {
        BlockState blockState = world.m_8055_(offsetPos);
        return blockState.m_60795_() || !blockState.m_60819_().m_76178_() && !blockState.m_60819_().m_76170_();
    }

    private Optional<Integer> fillFromBlockInRange(Level world, BlockPos basePos, IFluidHandler storageFluidHandler) {
        LinkedList<BlockPos> nextPositions = new LinkedList<BlockPos>();
        HashSet<BlockPos> searchedPositions = new HashSet<BlockPos>();
        nextPositions.add(basePos);
        while (!nextPositions.isEmpty()) {
            BlockPos pos = (BlockPos)nextPositions.poll();
            if (this.fillFromBlock(world, pos, storageFluidHandler)) {
                return Optional.of((int)(Math.max(1.0, Math.sqrt(basePos.m_123331_((Vec3i)pos))) * 20.0));
            }
            for (Direction dir : Direction.values()) {
                BlockPos offsetPos = pos.m_121955_(dir.m_122436_());
                if (searchedPositions.contains(offsetPos)) continue;
                searchedPositions.add(offsetPos);
                if (!(basePos.m_123331_((Vec3i)offsetPos) < 16.0)) continue;
                nextPositions.add(offsetPos);
            }
        }
        return Optional.empty();
    }

    private boolean fillFromBlock(Level world, BlockPos pos, IFluidHandler storageFluidHandler) {
        FluidState fluidState = world.m_6425_(pos);
        if (!fluidState.m_76178_()) {
            FluidBlockWrapper targetFluidHandler;
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                targetFluidHandler = new FluidBlockWrapper(fluidBlock, world, pos);
            } else if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                targetFluidHandler = new BucketPickupHandlerWrapper(bucketPickup, world, pos);
            } else {
                return false;
            }
            return this.fillFromFluidHandler((IFluidHandler)targetFluidHandler, storageFluidHandler);
        }
        return false;
    }

    private boolean handleFluidContainersInHandsOfNearbyPlayers(Level world, BlockPos pos, IFluidHandler storageFluidHandler) {
        AABB searchBox = new AABB(pos).m_82400_(3.0);
        for (Player player : world.m_6907_()) {
            if (!searchBox.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_()) || !this.handleFluidContainerInHands(player, storageFluidHandler)) continue;
            return true;
        }
        return false;
    }

    private boolean handleFluidContainerInHands(Player player, IFluidHandler storageFluidHandler) {
        return this.handleFluidContainerInHand(storageFluidHandler, player, InteractionHand.MAIN_HAND) || this.handleFluidContainerInHand(storageFluidHandler, player, InteractionHand.OFF_HAND);
    }

    private boolean handleFluidContainerInHand(IFluidHandler storageFluidHandler, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_41613_() != 1 || itemInHand == this.storageWrapper.getWrappedStorageStack()) {
            return false;
        }
        return itemInHand.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(itemFluidHandler -> {
            if (this.isInput()) {
                return this.fillFromHand(player, hand, (IFluidHandlerItem)itemFluidHandler, storageFluidHandler);
            }
            return this.fillContainerInHand(player, hand, (IFluidHandlerItem)itemFluidHandler, storageFluidHandler);
        }).orElse(false);
    }

    private boolean fillContainerInHand(Player player, InteractionHand hand, IFluidHandlerItem itemFluidHandler, IFluidHandler storageFluidHandler) {
        boolean ret = this.fillFluidHandler((IFluidHandler)itemFluidHandler, storageFluidHandler);
        if (ret) {
            player.m_21008_(hand, itemFluidHandler.getContainer());
        }
        return ret;
    }

    private boolean fillFluidHandler(IFluidHandler fluidHandler, IFluidHandler storageFluidHandler) {
        return this.fillFluidHandler(fluidHandler, storageFluidHandler, 1000);
    }

    private boolean fillFluidHandler(IFluidHandler fluidHandler, IFluidHandler storageFluidHandler, int maxFill) {
        boolean ret = false;
        for (int tank = 0; tank < storageFluidHandler.getTanks(); ++tank) {
            FluidStack tankFluid = storageFluidHandler.getFluidInTank(tank);
            if (tankFluid.isEmpty() || !this.fluidFilterLogic.fluidMatches(tankFluid) || FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)storageFluidHandler, (FluidStack)new FluidStack(tankFluid, maxFill), (boolean)true).isEmpty()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean fillFromHand(Player player, InteractionHand hand, IFluidHandlerItem itemFluidHandler, IFluidHandler storageFluidHandler) {
        if (this.fillFromFluidHandler((IFluidHandler)itemFluidHandler, storageFluidHandler)) {
            player.m_21008_(hand, itemFluidHandler.getContainer());
            return true;
        }
        return false;
    }

    private boolean fillFromFluidHandler(IFluidHandler fluidHandler, IFluidHandler storageFluidHandler) {
        return this.fillFromFluidHandler(fluidHandler, storageFluidHandler, 1000);
    }

    private boolean fillFromFluidHandler(IFluidHandler fluidHandler, IFluidHandler storageFluidHandler, int maxDrain) {
        FluidStack containedFluid = fluidHandler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
        if (!containedFluid.isEmpty() && this.fluidFilterLogic.fluidMatches(containedFluid)) {
            return !FluidUtil.tryFluidTransfer((IFluidHandler)storageFluidHandler, (IFluidHandler)fluidHandler, (FluidStack)containedFluid, (boolean)true).isEmpty();
        }
        return false;
    }

    public void setIsInput(boolean input) {
        NBTHelper.setBoolean(this.upgrade, "input", input);
        this.save();
    }

    public boolean isInput() {
        return NBTHelper.getBoolean(this.upgrade, "input").orElse(true);
    }

    public FluidFilterLogic getFluidFilterLogic() {
        return this.fluidFilterLogic;
    }

    public void setInteractWithHand(boolean interactWithHand) {
        NBTHelper.setBoolean(this.upgrade, "interactWithHand", interactWithHand);
        this.save();
    }

    public boolean shouldInteractWithHand() {
        return NBTHelper.getBoolean(this.upgrade, "interactWithHand").orElse(((PumpUpgradeItem)this.upgradeItem).getInteractWithHandDefault());
    }

    public void setInteractWithWorld(boolean interactWithWorld) {
        NBTHelper.setBoolean(this.upgrade, "interactWithWorld", interactWithWorld);
        this.save();
    }

    public boolean shouldInteractWithWorld() {
        return NBTHelper.getBoolean(this.upgrade, "interactWithWorld").orElse(((PumpUpgradeItem)this.upgradeItem).getInteractWithWorldDefault());
    }
}

