/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.ScaleUtils;

public class ScalePacket {
    final int id;
    final int quantity;
    final ResourceLocation[] typeIds;
    CompoundTag[] nbt = null;
    ScaleData[] scaleData = null;

    public ScalePacket(Entity entity, Collection<ScaleData> scales) {
        this.id = entity.m_19879_();
        this.quantity = scales.size();
        this.scaleData = scales.toArray(new ScaleData[this.quantity]);
        this.typeIds = new ResourceLocation[this.quantity];
        for (int i = 0; i < this.quantity; ++i) {
            this.typeIds[i] = ScaleRegistries.getId(ScaleRegistries.SCALE_TYPES, this.scaleData[i].getScaleType());
        }
    }

    protected ScalePacket(FriendlyByteBuf buf) {
        this.id = buf.m_130242_();
        this.quantity = buf.readInt();
        this.typeIds = new ResourceLocation[this.quantity];
        this.nbt = new CompoundTag[this.quantity];
        for (int i = 0; i < this.quantity; ++i) {
            this.typeIds[i] = buf.m_130281_();
            this.nbt[i] = ScaleUtils.buildScaleNbtFromPacketByteBuf(buf);
        }
    }

    public static void handle(ScalePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft client = Minecraft.m_91087_();
            Entity entity = client.f_91073_.m_6815_(msg.id);
            if (entity != null) {
                for (int i = 0; i < msg.quantity; ++i) {
                    if (!ScaleRegistries.SCALE_TYPES.containsKey((Object)msg.typeIds[i])) continue;
                    ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, msg.typeIds[i]).getScaleData(entity).readNbt(msg.nbt[i]);
                }
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.id);
        buf.writeInt(this.quantity);
        for (int i = 0; i < this.quantity; ++i) {
            buf.m_130085_(this.typeIds[i]);
            this.scaleData[i].toPacket(buf);
        }
    }
}

