/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public final class LatticeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Block block = adjState.m_60734_();
        if (block == state.m_60734_() && LatticeSkipPredicate.hasArm(state, side) && LatticeSkipPredicate.hasArm(adjState, side.m_122424_())) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (Utils.isY(side) && LatticeSkipPredicate.hasArm(state, side) && LatticeSkipPredicate.isFenceOrVerticalLattice(block, adjState)) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean isFenceOrVerticalLattice(Block block, BlockState state) {
        if (block == FBContent.blockFramedPost.get()) {
            return state.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y;
        }
        return block == FBContent.blockFramedFence.get();
    }

    private static boolean hasArm(BlockState state, Direction side) {
        return switch (side.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> (Boolean)state.m_61143_((Property)FramedProperties.X_AXIS);
            case Direction.Axis.Y -> (Boolean)state.m_61143_((Property)FramedProperties.Y_AXIS);
            case Direction.Axis.Z -> (Boolean)state.m_61143_((Property)FramedProperties.Z_AXIS);
        };
    }
}

