/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.background.example.with_input_string;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.api.background.MenuBackground;
import de.keksuccino.fancymenu.api.background.MenuBackgroundType;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class ExampleMenuBackgroundForInputString
extends MenuBackground {
    private ExternalTextureResourceLocation imageLocation = null;

    public ExampleMenuBackgroundForInputString(@Nonnull MenuBackgroundType type, String imagePath) {
        super("unused_identifier", type);
        File imageFile = new File(imagePath);
        if (imageFile.exists() && (imageFile.getPath().toLowerCase().endsWith(".jpg") || imageFile.getPath().toLowerCase().endsWith(".jpeg") || imageFile.getPath().toLowerCase().endsWith(".png"))) {
            this.imageLocation = TextureHandler.getResource((String)imageFile.getPath());
            if (this.imageLocation != null) {
                this.imageLocation.loadTexture();
            }
        }
    }

    @Override
    public void onOpenMenu() {
    }

    @Override
    public void render(PoseStack matrix, Screen screen, boolean keepAspectRatio) {
        try {
            if (this.imageLocation != null && this.imageLocation.isReady()) {
                RenderSystem.m_69478_();
                RenderUtils.bindTexture((ResourceLocation)this.imageLocation.getResourceLocation());
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!keepAspectRatio) {
                    GuiComponent.m_93133_((PoseStack)matrix, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)screen.f_96543_, (int)screen.f_96544_, (int)screen.f_96543_, (int)screen.f_96544_);
                } else {
                    int w = this.imageLocation.getWidth();
                    int h = this.imageLocation.getHeight();
                    double ratio = (double)w / (double)h;
                    int wfinal = (int)((double)screen.f_96544_ * ratio);
                    int screenCenterX = screen.f_96543_ / 2;
                    if (wfinal < screen.f_96543_) {
                        GuiComponent.m_93133_((PoseStack)matrix, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)screen.f_96543_, (int)screen.f_96544_, (int)screen.f_96543_, (int)screen.f_96544_);
                    } else {
                        GuiComponent.m_93133_((PoseStack)matrix, (int)(screenCenterX - wfinal / 2), (int)0, (float)1.0f, (float)1.0f, (int)wfinal, (int)screen.f_96544_, (int)wfinal, (int)screen.f_96544_);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

