/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.popup.FMPopup;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;

public class AutoScalingPopup
extends FMPopup {
    private LayoutEditorScreen parent;
    private AdvancedButton cancelButton;
    private AdvancedButton doneButton;
    private AdvancedTextField widthTextField;
    private AdvancedTextField heightTextField;
    protected Consumer<Boolean> callback = null;

    public AutoScalingPopup(LayoutEditorScreen parent, @Nullable Consumer<Boolean> callback) {
        super(240);
        this.callback = callback;
        this.parent = parent;
        this.cancelButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.yesno.cancel", (String[])new String[0]), true, press -> this.onCancelButtonPressed());
        this.addButton(this.cancelButton);
        this.doneButton = new AdvancedButton(0, 0, 80, 20, Locals.localize((String)"popup.done", (String[])new String[0]), true, press -> this.onDoneButtonPressed());
        this.addButton(this.doneButton);
        this.widthTextField = new AdvancedTextField(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        this.widthTextField.m_94144_("" + Minecraft.m_91087_().m_91268_().m_85443_());
        this.heightTextField = new AdvancedTextField(Minecraft.m_91087_().f_91062_, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler());
        this.heightTextField.m_94144_("" + Minecraft.m_91087_().m_91268_().m_85444_());
        KeyboardHandler.addKeyPressedListener(this::onEnterPressed);
        KeyboardHandler.addKeyPressedListener(this::onEscapePressed);
    }

    public void render(PoseStack matrix, int mouseX, int mouseY, Screen renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        float partial = Minecraft.m_91087_().m_91296_();
        Font font = Minecraft.m_91087_().f_91062_;
        int screenCenterX = renderIn.f_96543_ / 2;
        int screenCenterY = renderIn.f_96544_ / 2;
        AutoScalingPopup.m_93208_((PoseStack)matrix, (Font)font, (String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line1", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 90), (int)-1);
        AutoScalingPopup.m_93208_((PoseStack)matrix, (Font)font, (String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line2", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 80), (int)-1);
        AutoScalingPopup.m_93208_((PoseStack)matrix, (Font)font, (String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.basesize.popup.desc.line3", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 70), (int)-1);
        AutoScalingPopup.m_93208_((PoseStack)matrix, (Font)font, (String)Locals.localize((String)"general.width", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 50), (int)-1);
        this.widthTextField.f_93620_ = screenCenterX - this.widthTextField.m_5711_() / 2;
        this.widthTextField.f_93621_ = screenCenterY - 35;
        this.widthTextField.m_6305_(matrix, mouseX, mouseY, partial);
        AutoScalingPopup.m_93208_((PoseStack)matrix, (Font)font, (String)Locals.localize((String)"general.height", (String[])new String[0]), (int)screenCenterX, (int)(screenCenterY - 5), (int)-1);
        this.heightTextField.f_93620_ = screenCenterX - this.heightTextField.m_5711_() / 2;
        this.heightTextField.f_93621_ = screenCenterY + 10;
        this.heightTextField.m_6305_(matrix, mouseX, mouseY, partial);
        AutoScalingPopup.m_93208_((PoseStack)matrix, (Font)font, (String)(Locals.localize((String)"helper.creator.windowsize.currentwidth", (String[])new String[0]) + ": " + Minecraft.m_91087_().m_91268_().m_85443_()), (int)screenCenterX, (int)(screenCenterY + 45), (int)-1);
        AutoScalingPopup.m_93208_((PoseStack)matrix, (Font)font, (String)(Locals.localize((String)"helper.creator.windowsize.currentheight", (String[])new String[0]) + ": " + Minecraft.m_91087_().m_91268_().m_85444_()), (int)screenCenterX, (int)(screenCenterY + 55), (int)-1);
        this.doneButton.f_93620_ = screenCenterX - this.doneButton.m_5711_() - 5;
        this.doneButton.f_93621_ = screenCenterY + 80;
        this.cancelButton.f_93620_ = screenCenterX + 5;
        this.cancelButton.f_93621_ = screenCenterY + 80;
        this.renderButtons(matrix, mouseX, mouseY);
    }

    protected void onDoneButtonPressed() {
        try {
            if (MathUtils.isInteger((String)this.widthTextField.m_94155_()) && MathUtils.isInteger((String)this.heightTextField.m_94155_())) {
                int w = Integer.parseInt(this.widthTextField.m_94155_());
                int h = Integer.parseInt(this.heightTextField.m_94155_());
                if (w > 0 && h > 0) {
                    this.parent.history.saveSnapshot(this.parent.history.createSnapshot());
                    this.parent.autoScalingWidth = w;
                    this.parent.autoScalingHeight = h;
                    this.answerCallback(true);
                } else {
                    this.answerCallback(false);
                    LayoutEditorScreen.displayNotification(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.error", (String[])new String[0]), (String)"%n%"));
                }
            } else {
                this.answerCallback(false);
                LayoutEditorScreen.displayNotification(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.editor.properties.autoscale.error", (String[])new String[0]), (String)"%n%"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDisplayed(false);
    }

    protected void onCancelButtonPressed() {
        this.answerCallback(false);
        this.setDisplayed(false);
    }

    protected void answerCallback(boolean b) {
        if (this.callback != null) {
            this.callback.accept(b);
        }
    }

    public void onEnterPressed(KeyboardData d) {
        if (d.keycode == 257 && this.isDisplayed() && this.doneButton != null && this.doneButton.f_93624_) {
            this.onDoneButtonPressed();
        }
    }

    public void onEscapePressed(KeyboardData d) {
        if (d.keycode == 256 && this.isDisplayed()) {
            this.onCancelButtonPressed();
        }
    }
}

