/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop;

import fuzs.airhop.AirHop;
import fuzs.airhop.capability.AirHopsCapability;
import fuzs.airhop.handler.PlayerFallHandler;
import fuzs.airhop.init.ModRegistry;
import fuzs.puzzleslib.capability.ForgeCapabilityController;
import fuzs.puzzleslib.core.CoreServices;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="airhop")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AirHopForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CoreServices.FACTORIES.modConstructor("airhop").accept(new AirHop());
        AirHopForge.registerCapabilities();
        AirHopForge.registerHandlers();
    }

    private static void registerCapabilities() {
        ForgeCapabilityController.setCapabilityToken(ModRegistry.AIR_HOPS_CAPABILITY, (CapabilityToken)new CapabilityToken<AirHopsCapability>(){});
    }

    private static void registerHandlers() {
        PlayerFallHandler playerFallHandler = new PlayerFallHandler();
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase != TickEvent.Phase.START) {
                return;
            }
            playerFallHandler.onPlayerTick$start(evt.player);
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> evt.setDistance(playerFallHandler.onLivingFall(evt.getEntity(), evt.getDistance(), evt.getDamageMultiplier())));
    }
}

