/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop.client.handler;

import fuzs.airhop.AirHop;
import fuzs.airhop.capability.AirHopsCapability;
import fuzs.airhop.config.ServerConfig;
import fuzs.airhop.handler.PlayerFallHandler;
import fuzs.airhop.init.ModRegistry;
import fuzs.airhop.mixin.client.accessor.LivingEntityAccessor;
import fuzs.airhop.network.client.C2SAirHopMessage;
import fuzs.puzzleslib.network.Message;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.lang3.mutable.MutableInt;

public class AirHopHandler {
    public void onPlayerTick$end(Player player) {
        if (player.m_150110_().f_35935_) {
            ((LivingEntityAccessor)player).setNoJumpDelay(10);
        } else if (((LivingEntityAccessor)player).getJumping() && ((LivingEntityAccessor)player).getNoJumpDelay() == 0 && this.attemptJump(player)) {
            ((LivingEntityAccessor)player).setNoJumpDelay(10);
            AirHop.NETWORK.sendToServer((Message)new C2SAirHopMessage());
        }
    }

    private boolean attemptJump(Player player) {
        AirHopsCapability capability;
        Optional optional;
        if (this.canJump(player) && this.isSaturated(player) && (optional = ModRegistry.AIR_HOPS_CAPABILITY.maybeGet((Object)player)).isPresent() && (capability = (AirHopsCapability)optional.get()).getAirHops() < AirHopHandler.getAllEnchantmentLevels(player.m_6168_(), (Enchantment)ModRegistry.AIR_HOP_ENCHANTMENT.get())) {
            player.m_6135_();
            player.m_183634_();
            capability.addAirHop();
            return true;
        }
        return false;
    }

    private boolean canJump(Player player) {
        if (!(player.m_20096_() || ((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).fallingOnly && !(PlayerFallHandler.getJumpHeight(player) / 2.0f < player.f_19789_) || player.m_20159_() || player.m_150110_().f_35935_ || player.m_6147_())) {
            return !player.m_20069_() && !player.m_20077_();
        }
        return false;
    }

    private boolean isSaturated(Player player) {
        return player.m_150110_().f_35936_ || !((ServerConfig)AirHop.CONFIG.get(ServerConfig.class)).disableOnHungry || player.m_36324_().m_38702_() > 6;
    }

    private static int getAllEnchantmentLevels(Iterable<ItemStack> armorItems, Enchantment enchantment) {
        MutableInt mutableint = new MutableInt();
        AirHopHandler.runIterationOnInventory((enchantment1, level) -> {
            if (enchantment1 == enchantment) {
                mutableint.add((Number)level);
            }
        }, armorItems);
        return mutableint.intValue();
    }

    private static void runIterationOnItem(BiConsumer<Enchantment, Integer> enchantmentVisitor, ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            ListTag listTag = itemStack.m_41785_();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                Registry.f_122825_.m_6612_(EnchantmentHelper.m_182446_((CompoundTag)compoundTag)).ifPresent(enchantment -> enchantmentVisitor.accept((Enchantment)enchantment, EnchantmentHelper.m_182438_((CompoundTag)compoundTag)));
            }
        }
    }

    private static void runIterationOnInventory(BiConsumer<Enchantment, Integer> enchantmentVisitor, Iterable<ItemStack> iterable) {
        for (ItemStack itemStack : iterable) {
            AirHopHandler.runIterationOnItem(enchantmentVisitor, itemStack);
        }
    }
}

