/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.entity.boat;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import potionstudios.byg.BYG;
import potionstudios.byg.common.entity.boat.BYGBoat;
import potionstudios.byg.util.ModPlatform;

public class BYGBoatRenderer
extends EntityRenderer<BYGBoat> {
    private final Map<BYGBoat.BYGType, Pair<ResourceLocation, BoatModel>> boatResources;

    public BYGBoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = ModPlatform.INSTANCE.hasLoadErrors() ? new HashMap<BYGBoat.BYGType, Pair<ResourceLocation, BoatModel>>() : (Map)Stream.of(BYGBoat.BYGType.values()).collect(ImmutableMap.toImmutableMap(bygType -> bygType, bygType -> Pair.of((Object)BYG.createLocation(BYGBoatRenderer.getTextureLocation(bygType, hasChest)), (Object)this.createBoatModel(context, (BYGBoat.BYGType)((Object)bygType), hasChest))));
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, BYGBoat.BYGType bygType, boolean hasChest) {
        ModelLayerLocation modellayerlocation = hasChest ? BYGBoatRenderer.createChestBoatModelName(bygType) : BYGBoatRenderer.createBoatModelName(bygType);
        return new BoatModel(context.m_174023_(modellayerlocation), hasChest);
    }

    public static ModelLayerLocation createChestBoatModelName(BYGBoat.BYGType type) {
        return new ModelLayerLocation(BYG.createLocation("chest_boat/" + type.getName()), "main");
    }

    public static ModelLayerLocation createBoatModelName(BYGBoat.BYGType type) {
        return new ModelLayerLocation(BYG.createLocation("boat/" + type.getName()), "main");
    }

    private static String getTextureLocation(BYGBoat.BYGType bygType, boolean hasChest) {
        return hasChest ? "textures/entity/chest_boat/" + bygType.getName() + ".png" : "textures/entity/boat/" + bygType.getName() + ".png";
    }

    public void render(BYGBoat boat, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource multiBufferSource, int packedLightIn) {
        float k;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.375, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float h = (float)boat.m_38385_() - partialTicks;
        float j = boat.m_38384_() - partialTicks;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(k = boat.m_38352_(partialTicks)), (float)0.0f)) {
            matrixStackIn.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), boat.m_38352_(partialTicks), true));
        }
        Pair<ResourceLocation, BoatModel> pair = this.boatResources.get((Object)boat.getBYGBoatType());
        ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
        BoatModel boatModel = (BoatModel)pair.getSecond();
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        boatModel.m_6973_((Boat)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(boatModel.m_103119_(resourceLocation));
        boatModel.m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer vertexConsumer2 = multiBufferSource.m_6299_(RenderType.m_110478_());
            boatModel.m_102282_().m_104301_(matrixStackIn, vertexConsumer2, packedLightIn, OverlayTexture.f_118083_);
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)boat, entityYaw, partialTicks, matrixStackIn, multiBufferSource, packedLightIn);
    }

    public ResourceLocation getTextureLocation(BYGBoat boat) {
        return (ResourceLocation)this.boatResources.get(boat.m_38387_()).getFirst();
    }
}

