/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.LongFunction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import potionstudios.byg.mixin.access.WeightedListAccess;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaFactory;
import terrablender.worldgen.noise.AreaTransformer0;
import terrablender.worldgen.noise.AreaTransformer1;
import terrablender.worldgen.noise.LayeredNoiseUtil;
import terrablender.worldgen.noise.ZoomLayer;

public class LayerUtil {
    public static Area createLayers(Registry<Biome> biomeRegistry, long worldSeed, SimpleWeightedRandomList<ResourceKey<Biome>> biomes, int regionSize, Path configPath) {
        LongFunction<AreaContext> contextFactory = seedModifier -> new AreaContext(25, worldSeed, seedModifier);
        AreaFactory factory = new InitLayer(biomes, biomeRegistry, configPath).run(contextFactory.apply(1L));
        factory = ZoomLayer.FUZZY.run(contextFactory.apply(2000L), factory);
        factory = LayeredNoiseUtil.zoom((long)2001L, (AreaTransformer1)ZoomLayer.FUZZY, (AreaFactory)factory, (int)3, contextFactory);
        factory = LayeredNoiseUtil.zoom((long)1001L, (AreaTransformer1)ZoomLayer.NORMAL, (AreaFactory)factory, (int)regionSize, contextFactory);
        return factory.make();
    }

    private static class InitLayer
    implements AreaTransformer0 {
        private final SimpleWeightedRandomList<ResourceKey<Biome>> biomes;
        private final Registry<Biome> biomeRegistry;
        private final Path path;
        private final int totalWeight;
        private final List<WeightedEntry> entries;

        public InitLayer(SimpleWeightedRandomList<ResourceKey<Biome>> biomes, Registry<Biome> biomeRegistry, Path path) {
            this.biomes = biomes;
            this.biomeRegistry = biomeRegistry;
            this.path = path;
            this.totalWeight = ((WeightedListAccess)this.biomes).byg_getTotalWeight();
            this.entries = ((WeightedListAccess)this.biomes).byg_getItems();
        }

        public int apply(AreaContext areaContext, int x, int z) {
            if (this.totalWeight == 0) {
                return this.biomeRegistry.m_7447_((Object)((Biome)this.biomeRegistry.m_6246_(Biomes.f_48174_)));
            }
            Optional weightedItem = WeightedRandom.m_146314_(this.entries, (int)areaContext.nextRandom(this.totalWeight));
            WeightedEntry.Wrapper resourceKeyWrapper = (WeightedEntry.Wrapper)weightedItem.get();
            ResourceKey key = (ResourceKey)resourceKeyWrapper.m_146310_();
            if (!this.biomeRegistry.m_142003_(key)) {
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid biome in the registry, fix the ID or remove the json entry from the config: \"%s\" and relaunch Minecraft...", key, this.path));
            }
            return this.biomeRegistry.m_7447_((Object)((Biome)this.biomeRegistry.m_6246_(key)));
        }
    }
}

