/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersClient;
import com.supermartijn642.chunkloaders.LegacyChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ClientChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.ServerChunkLoadingCapability;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersBlockStateGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersLanguageGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersLootTableGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersModelGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersRecipeGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersTagGenerator;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderAdded;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderRemoved;
import com.supermartijn642.chunkloaders.packet.PackedStartLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedStopLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedTogglePlayerActivity;
import com.supermartijn642.chunkloaders.packet.PacketFullCapabilityData;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chunkloaders")
public class ChunkLoaders {
    public static Capability<ChunkLoadingCapability> CHUNK_LOADING_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkLoadingCapability>(){});
    public static final Logger LOGGER = LogManager.getLogger((String)"chunkloaders");
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"chunkloaders");
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"chunkloaders", ChunkLoaderType.ADVANCED::getItem);

    public ChunkLoaders() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, this::attachCapabilities);
        CHANNEL.registerMessage(PackedChunkLoaderAdded.class, PackedChunkLoaderAdded::new, true);
        CHANNEL.registerMessage(PackedChunkLoaderRemoved.class, PackedChunkLoaderRemoved::new, true);
        CHANNEL.registerMessage(PackedStartLoadingChunk.class, PackedStartLoadingChunk::new, true);
        CHANNEL.registerMessage(PackedStopLoadingChunk.class, PackedStopLoadingChunk::new, true);
        CHANNEL.registerMessage(PackedTogglePlayerActivity.class, PackedTogglePlayerActivity::new, true);
        CHANNEL.registerMessage(PacketFullCapabilityData.class, PacketFullCapabilityData::new, true);
        CHANNEL.registerMessage(PacketToggleChunk.class, PacketToggleChunk::new, true);
        ChunkLoaders.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            ChunkLoadersClient.register();
        }
        ChunkLoaders.registerGenerators();
    }

    public void init(FMLCommonSetupEvent e) {
        ForgeChunkManager.setForcedChunkLoadingCallback((String)"chunkloaders", (level, ticketHelper) -> {
            level.getCapability(CHUNK_LOADING_CAPABILITY).ifPresent(capability -> capability.castServer().onLoadLevel(ticketHelper));
            level.getCapability(LegacyChunkLoadingCapability.TRACKER_CAPABILITY).ifPresent(capability -> capability.onLoadLevel(ticketHelper));
        });
    }

    public void registerCapabilities(RegisterCapabilitiesEvent e) {
        e.register(ChunkLoadingCapability.class);
        LegacyChunkLoadingCapability.register(e);
    }

    public void attachCapabilities(AttachCapabilitiesEvent<Level> e) {
        Level level = (Level)e.getObject();
        final LazyOptional tracker = LazyOptional.of(() -> level.f_46443_ ? new ClientChunkLoadingCapability(level) : new ServerChunkLoadingCapability(level));
        e.addCapability(new ResourceLocation("chunkloaders", "chunk_loading_capability"), (ICapabilityProvider)new ICapabilitySerializable<Tag>(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CHUNK_LOADING_CAPABILITY ? tracker.cast() : LazyOptional.empty();
            }

            public Tag serializeNBT() {
                return tracker.map(ChunkLoadingCapability::write).orElse(null);
            }

            public void deserializeNBT(Tag nbt) {
                tracker.ifPresent(cap -> cap.read((CompoundTag)nbt));
            }
        });
        e.addListener(() -> ((LazyOptional)tracker).invalidate());
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"chunkloaders");
        for (ChunkLoaderType type : ChunkLoaderType.values()) {
            handler.registerBlockCallback(type::registerBlock);
            handler.registerBlockEntityTypeCallback(type::registerBlockEntity);
            handler.registerItemCallback(type::registerItem);
        }
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"chunkloaders");
        handler.addGenerator(ChunkLoadersModelGenerator::new);
        handler.addGenerator(ChunkLoadersBlockStateGenerator::new);
        handler.addGenerator(ChunkLoadersLanguageGenerator::new);
        handler.addGenerator(ChunkLoadersLootTableGenerator::new);
        handler.addGenerator(ChunkLoadersRecipeGenerator::new);
        handler.addGenerator(ChunkLoadersRecipeGenerator::new);
        handler.addGenerator(ChunkLoadersTagGenerator::new);
    }
}

