/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server.world.data.villageComponents;

import fabric.net.mca.Config;
import fabric.net.mca.ProfessionsMCA;
import fabric.net.mca.entity.EquipmentSet;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.server.world.data.Village;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_3218;
import net.minecraft.class_3852;

public class VillageGuardsManager {
    private final Village village;

    public VillageGuardsManager(Village village) {
        this.village = village;
    }

    public void spawnGuards(class_3218 world) {
        int guardCapacity = (int)Math.ceil((float)this.village.getPopulation() * Config.getInstance().guardSpawnFraction);
        int guards = 0;
        int citizen = 0;
        List<VillagerEntityMCA> villagers = this.village.getResidents(world);
        LinkedList<VillagerEntityMCA> nonGuards = new LinkedList<VillagerEntityMCA>();
        for (VillagerEntityMCA villager : villagers) {
            if (villager.isGuard()) {
                ++guards;
                continue;
            }
            if (!villager.method_6109() && !villager.isProfessionImportant() && villager.method_19269() == 0 && villager.method_7231().method_16925() <= 1) {
                nonGuards.add(villager);
            }
            ++citizen;
        }
        guards = (int)((double)guards + Math.ceil((float)(this.village.getPopulation() - guards - citizen) * Config.getInstance().guardSpawnFraction));
        if (nonGuards.size() > 0 && guards < guardCapacity) {
            VillagerEntityMCA villager = (VillagerEntityMCA)nonGuards.get(world.field_9229.method_43048(nonGuards.size()));
            villager.setProfession(guards % 2 == 0 ? (class_3852)ProfessionsMCA.GUARD.get() : (class_3852)ProfessionsMCA.ARCHER.get());
        }
    }

    public EquipmentSet getGuardEquipment(class_3852 profession, class_1268 dominantHand) {
        if (profession == ProfessionsMCA.ARCHER.get()) {
            if (this.village.hasBuilding("armory")) {
                if (this.village.hasBuilding("blacksmith")) {
                    return VillageGuardsManager.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_2, EquipmentSet.ARCHER_2_LEFT);
                }
                return VillageGuardsManager.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_1, EquipmentSet.ARCHER_1_LEFT);
            }
            return VillageGuardsManager.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_0, EquipmentSet.ARCHER_0_LEFT);
        }
        if (this.village.hasBuilding("armory")) {
            if (this.village.hasBuilding("blacksmith")) {
                return EquipmentSet.GUARD_2;
            }
            return EquipmentSet.GUARD_1;
        }
        return VillageGuardsManager.getEquipmentFor(dominantHand, EquipmentSet.GUARD_0, EquipmentSet.GUARD_0_LEFT);
    }

    public static EquipmentSet getEquipmentFor(class_1268 dominantHand, EquipmentSet rightSet, EquipmentSet leftSet) {
        return dominantHand == class_1268.field_5810 && leftSet != null ? leftSet : rightSet;
    }
}

