/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca;

import forge.net.mca.Config;
import forge.net.mca.DestinyManager;
import forge.net.mca.KeyBindings;
import forge.net.mca.MCA;
import forge.net.mca.client.gui.SkinLibraryScreen;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.network.c2s.ConfigRequest;
import forge.net.mca.network.c2s.PlayerDataRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class MCAClient {
    public static VillagerEntityMCA fallbackVillager;
    public static final Map<UUID, VillagerLike<?>> playerData;
    public static final Set<UUID> playerDataRequests;
    private static final DestinyManager destinyManager;

    public static DestinyManager getDestinyManager() {
        return destinyManager;
    }

    public static void onLogin() {
        playerDataRequests.clear();
        NetworkHandler.sendToServer(new ConfigRequest());
    }

    public static boolean useGeneticsRenderer(UUID uuid) {
        if (MCA.isPlayerRendererAllowed()) {
            if (!playerDataRequests.contains(uuid)) {
                playerDataRequests.add(uuid);
                NetworkHandler.sendToServer(new PlayerDataRequest(uuid));
            }
            return playerData.containsKey(uuid) && playerData.get(uuid).getPlayerModel() != VillagerLike.PlayerModel.VANILLA;
        }
        return false;
    }

    public static boolean useVillagerRenderer(UUID uuid) {
        return MCAClient.useGeneticsRenderer(uuid) && playerData.get(uuid).getPlayerModel() == VillagerLike.PlayerModel.VILLAGER;
    }

    public static boolean renderArms(UUID uuid, String key) {
        return MCAClient.useVillagerRenderer(uuid) && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("arms") || ((String)entry.getValue()).equals(key)).noneMatch(entry -> MCA.doesModExist((String)entry.getKey()));
    }

    public static void tickClient(Minecraft client) {
        destinyManager.tick(client);
        if (KeyBindings.SKIN_LIBRARY.m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new SkinLibraryScreen());
        }
    }

    static {
        playerData = new HashMap();
        playerDataRequests = new HashSet<UUID>();
        destinyManager = new DestinyManager();
    }
}

