/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client;

import forge.net.mca.entity.CommonSpeechManager;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.util.LimitedLinkedHashMap;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class SpeechManager {
    public static final SpeechManager INSTANCE = new SpeechManager();
    private final LimitedLinkedHashMap<UUID, EntityBoundSoundInstance> currentlyPlaying = new LimitedLinkedHashMap(10);
    private final RandomSource threadSafeRandom = RandomSource.m_216337_();

    public void onChatMessage(Component message, UUID sender) {
        if (CommonSpeechManager.INSTANCE.translations.containsKey(message.m_214077_())) {
            this.speak((String)CommonSpeechManager.INSTANCE.translations.get(message.m_214077_()), sender);
        } else {
            for (Component sibling : message.m_7360_()) {
                if (!CommonSpeechManager.INSTANCE.translations.containsKey(sibling.m_214077_())) continue;
                this.speak((String)CommonSpeechManager.INSTANCE.translations.get(sibling.m_214077_()), sender);
            }
        }
    }

    private void speak(String phrase, UUID sender) {
        if (this.currentlyPlaying.containsKey(sender) && Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)this.currentlyPlaying.get(sender))) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ != null) {
            VillagerEntityMCA villager = null;
            for (Entity entity : client.f_91073_.m_104735_()) {
                if (!(entity instanceof VillagerEntityMCA)) continue;
                VillagerEntityMCA v = (VillagerEntityMCA)entity;
                if (!entity.m_20148_().equals(sender)) continue;
                villager = v;
                break;
            }
            if (villager != null) {
                Collection keys;
                if (villager.isSpeechImpaired()) {
                    return;
                }
                if (villager.isToYoungToSpeak()) {
                    return;
                }
                float pitch = villager.m_6100_();
                float gene = villager.getGenetics().getGene(Genetics.VOICE_TONE);
                int tone = Math.min(9, (int)Math.floor(gene * 10.0f));
                ResourceLocation sound = new ResourceLocation("mca_voices", "%s/%s_%d".formatted(phrase, villager.getGenetics().getGender().binary().getStrName(), tone).toLowerCase(Locale.ROOT));
                if (client.f_91073_ != null && client.f_91074_ != null && (keys = client.m_91106_().m_120354_()).contains(sound)) {
                    EntityBoundSoundInstance instance = new EntityBoundSoundInstance(new SoundEvent(sound), SoundSource.NEUTRAL, 1.0f, pitch, (Entity)villager, this.threadSafeRandom.m_188505_());
                    this.currentlyPlaying.put(sender, instance);
                    client.m_91106_().m_120367_((SoundInstance)instance);
                }
            }
        }
    }
}

