/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.network.c2s.CallToPlayerMessage;
import forge.net.mca.network.c2s.GetFamilyRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WhistleScreen
extends Screen {
    private List<String> keys = new ArrayList<String>();
    private CompoundTag villagerData = new CompoundTag();
    private VillagerEntityMCA dummy;
    private Button selectionLeftButton;
    private Button selectionRightButton;
    private Button villagerNameButton;
    private Button callButton;
    private int loadingAnimationTicks;
    private int selectedIndex;

    public WhistleScreen() {
        super((Component)Component.m_237115_((String)"gui.whistle.title"));
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.loadingAnimationTicks != -1) {
            ++this.loadingAnimationTicks;
        }
        if (this.loadingAnimationTicks >= 20) {
            this.loadingAnimationTicks = 0;
        }
    }

    public void m_7856_() {
        NetworkHandler.sendToServer(new GetFamilyRequest());
        this.selectionLeftButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 123, this.f_96544_ / 2 + 65, 20, 20, (Component)Component.m_237113_((String)"<<"), b -> {
            this.selectedIndex = this.selectedIndex == 0 ? this.keys.size() - 1 : --this.selectedIndex;
            this.setVillagerData(this.selectedIndex);
        }));
        this.selectionRightButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 103, this.f_96544_ / 2 + 65, 20, 20, (Component)Component.m_237113_((String)">>"), b -> {
            this.selectedIndex = this.selectedIndex == this.keys.size() - 1 ? 0 : ++this.selectedIndex;
            this.setVillagerData(this.selectedIndex);
        }));
        this.villagerNameButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 65, 200, 20, (Component)Component.m_237113_((String)""), b -> {}));
        this.callButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 90, 60, 20, (Component)Component.m_237115_((String)"gui.button.call"), b -> {
            NetworkHandler.sendToServer(new CallToPlayerMessage(UUID.fromString(this.keys.get(this.selectedIndex))));
            Objects.requireNonNull(this.f_96541_).m_91152_(null);
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 40, this.f_96544_ / 2 + 90, 60, 20, (Component)Component.m_237115_((String)"gui.button.exit"), b -> Objects.requireNonNull(this.f_96541_).m_91152_(null)));
        this.toggleButtons(false);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6305_(PoseStack transform, int sizeX, int sizeY, float offset) {
        this.m_7333_(transform);
        WhistleScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.whistle.title"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 100), (int)0xFFFFFF);
        if (this.loadingAnimationTicks != -1) {
            String loadingMsg = new String(new char[this.loadingAnimationTicks / 5 % 4]).replace("\u0000", ".");
            WhistleScreen.m_93243_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.loading").m_7220_((Component)Component.m_237113_((String)loadingMsg)), (int)(this.f_96543_ / 2 - 20), (int)(this.f_96544_ / 2 - 10), (int)0xFFFFFF);
        } else if (this.keys.size() == 0) {
            WhistleScreen.m_93215_((PoseStack)transform, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.whistle.noFamily"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 50), (int)0xFFFFFF);
        } else {
            WhistleScreen.m_93208_((PoseStack)transform, (Font)this.f_96547_, (String)(this.selectedIndex + 1 + " / " + this.keys.size()), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 50), (int)0xFFFFFF);
        }
        this.drawDummy();
        super.m_6305_(transform, sizeX, sizeY, offset);
    }

    private void drawDummy() {
        int posX = this.f_96543_ / 2;
        int posY = this.f_96544_ / 2 + 45;
        if (this.dummy != null) {
            InventoryScreen.m_98850_((int)posX, (int)posY, (int)60, (float)0.0f, (float)0.0f, (LivingEntity)this.dummy);
        }
    }

    public void setVillagerData(@NotNull CompoundTag data) {
        this.villagerData = data;
        this.keys = new ArrayList<String>(data.m_128431_());
        this.loadingAnimationTicks = -1;
        this.selectedIndex = 0;
        this.setVillagerData(0);
    }

    private void setVillagerData(int index) {
        if (this.keys.size() > 0) {
            CompoundTag firstData = this.villagerData.m_128469_(this.keys.get(index));
            this.dummy = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).m_20615_((Level)Minecraft.m_91087_().f_91073_);
            this.dummy.m_7378_(firstData);
            this.villagerNameButton.m_93666_(this.dummy.m_5446_());
            this.toggleButtons(true);
        } else {
            this.toggleButtons(false);
        }
    }

    private void toggleButtons(boolean enabled) {
        this.selectionLeftButton.f_93623_ = enabled;
        this.selectionRightButton.f_93623_ = enabled;
        this.callButton.f_93623_ = enabled;
    }
}

