/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.ConversationManager;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class DeliverMessageTask
extends Behavior<VillagerEntityMCA> {
    private static final int MAX_COOLDOWN = 10;
    private static final int TALKING_TIME_MIN = 100;
    private static final int TALKING_TIME_MAX = 500;
    private static final long MIN_TIME_BETWEEN_SOUND = 6000L;
    private Optional<ConversationManager.Message> message = Optional.empty();
    private int cooldown;
    private int talked;
    private long lastInteraction = Long.MIN_VALUE;
    private Vec3 lastInteractionPos;

    public DeliverMessageTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26374_, (Object)MemoryStatus.REGISTERED), 600);
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = 10;
        this.message = DeliverMessageTask.getMessage(villager);
        return this.message.isPresent() && DeliverMessageTask.isWithinSeeRange(villager, this.message.get().getReceiver());
    }

    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.message.ifPresent(m -> {
            this.talked = 0;
        });
    }

    protected boolean shouldKeepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.talked < this.getMaxTalkingTime() && !villager.getVillagerBrain().isPanicking() && !villager.m_5803_();
    }

    private int getMaxTalkingTime() {
        Vec3 pos;
        if (this.message.isPresent() && this.lastInteractionPos != null && this.lastInteractionPos.m_82509_((Position)(pos = this.message.get().getReceiver().m_20182_()), 1.0)) {
            return 500;
        }
        return 100;
    }

    protected void keepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.message.ifPresent(m -> {
            Entity patt2730$temp = m.getReceiver();
            if (patt2730$temp instanceof LivingEntity) {
                LivingEntity e = (LivingEntity)patt2730$temp;
                villager.m_6274_().m_21879_(MemoryModuleType.f_26374_, (Object)e);
                BehaviorUtils.m_22595_((LivingEntity)villager, (LivingEntity)e);
            }
            if (this.talked == 0) {
                if (DeliverMessageTask.isWithinRange(villager, m.getReceiver())) {
                    if (time - this.lastInteraction > 6000L) {
                        villager.playWelcomeSound();
                    }
                    this.lastInteraction = time;
                    this.lastInteractionPos = m.getReceiver().m_20182_();
                    m.deliver();
                    this.talked = 1;
                } else {
                    BehaviorUtils.m_22590_((LivingEntity)villager, (Entity)m.getReceiver(), (float)0.65f, (int)2);
                }
            } else {
                BehaviorUtils.m_22590_((LivingEntity)villager, (Entity)m.getReceiver(), (float)0.45f, (int)2);
                ++this.talked;
            }
        });
    }

    protected void finishRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.message = Optional.empty();
        villager.m_6274_().m_21936_(MemoryModuleType.f_26374_);
        villager.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        villager.m_6274_().m_21936_(MemoryModuleType.f_26371_);
    }

    private static Optional<ConversationManager.Message> getMessage(VillagerEntityMCA villager) {
        return villager.conversationManager.getCurrentMessage();
    }

    private static boolean isWithinRange(VillagerEntityMCA villager, Entity player) {
        if (villager.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get()).isPresent()) {
            return true;
        }
        return villager.m_20183_().m_123314_((Vec3i)player.m_20183_(), 3.0);
    }

    private static boolean isWithinSeeRange(VillagerEntityMCA villager, Entity player) {
        return villager.m_20183_().m_123314_((Vec3i)player.m_20183_(), 64.0);
    }
}

